/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.RequiresApi;
import androidx.appcompat.widget.AppCompatButton;
import androidx.constraintlayout.widget.R;

public class MotionButton
extends AppCompatButton {
    private float mRoundPercent = 0.0f;
    private float mRound = Float.NaN;
    private Path mPath;
    ViewOutlineProvider mViewOutlineProvider;
    RectF mRect;

    public MotionButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MotionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MotionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setPadding(0, 0, 0, 0);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ImageFilterView);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ImageFilterView_round) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(a.getDimension(attr, 0.0f));
                    continue;
                }
                if (attr != R.styleable.ImageFilterView_roundPercent || Build.VERSION.SDK_INT < 21) continue;
                this.setRoundPercent(a.getFloat(attr, 0.0f));
            }
            a.recycle();
        }
    }

    @RequiresApi(value=21)
    public void setRoundPercent(float round) {
        boolean change = this.mRoundPercent != round;
        this.mRoundPercent = round;
        if (this.mRoundPercent != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = MotionButton.this.getWidth();
                            int h = MotionButton.this.getHeight();
                            float r = (float)Math.min(w, h) * MotionButton.this.mRoundPercent / 2.0f;
                            outline.setRoundRect(0, 0, w, h, r);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            float r = (float)Math.min(w, h) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, r, r, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    @RequiresApi(value=21)
    public void setRound(float round) {
        if (Float.isNaN(round)) {
            this.mRound = round;
            float tmp = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(tmp);
            return;
        }
        boolean change = this.mRound != round;
        this.mRound = round;
        if (this.mRound != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = MotionButton.this.getWidth();
                            int h = MotionButton.this.getHeight();
                            outline.setRoundRect(0, 0, w, h, MotionButton.this.mRound);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, this.mRound, this.mRound, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getRound() {
        return this.mRound;
    }

    public void draw(Canvas canvas) {
        boolean clip = false;
        if (Build.VERSION.SDK_INT < 21 && this.mRound != 0.0f && this.mPath != null) {
            clip = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
        if (clip) {
            canvas.restore();
        }
    }
}

