/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.annotation.SuppressLint;
import android.location.GnssStatus;
import android.location.GpsStatus;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.location.GnssStatusWrapper;
import androidx.core.location.GpsStatusWrapper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class GnssStatusCompat {
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_UNKNOWN = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_GPS = 1;
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_SBAS = 2;
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_GLONASS = 3;
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_QZSS = 4;
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_BEIDOU = 5;
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_GALILEO = 6;
    @SuppressLint(value={"InlinedApi"})
    public static final int CONSTELLATION_IRNSS = 7;

    @RequiresApi(value=24)
    @NonNull
    public static GnssStatusCompat wrap(@NonNull GnssStatus gnssStatus) {
        return new GnssStatusWrapper(gnssStatus);
    }

    @SuppressLint(value={"ReferencesDeprecated"})
    @NonNull
    public static GnssStatusCompat wrap(@NonNull GpsStatus gpsStatus) {
        return new GpsStatusWrapper(gpsStatus);
    }

    GnssStatusCompat() {
    }

    @IntRange(from=0L)
    public abstract int getSatelliteCount();

    public abstract int getConstellationType(@IntRange(from=0L) int var1);

    @IntRange(from=1L, to=200L)
    public abstract int getSvid(@IntRange(from=0L) int var1);

    @FloatRange(from=0.0, to=63.0)
    public abstract float getCn0DbHz(@IntRange(from=0L) int var1);

    @FloatRange(from=-90.0, to=90.0)
    public abstract float getElevationDegrees(@IntRange(from=0L) int var1);

    @FloatRange(from=0.0, to=360.0)
    public abstract float getAzimuthDegrees(@IntRange(from=0L) int var1);

    public abstract boolean hasEphemerisData(@IntRange(from=0L) int var1);

    public abstract boolean hasAlmanacData(@IntRange(from=0L) int var1);

    public abstract boolean usedInFix(@IntRange(from=0L) int var1);

    public abstract boolean hasCarrierFrequencyHz(@IntRange(from=0L) int var1);

    @FloatRange(from=0.0)
    public abstract float getCarrierFrequencyHz(@IntRange(from=0L) int var1);

    public abstract boolean hasBasebandCn0DbHz(@IntRange(from=0L) int var1);

    @FloatRange(from=0.0, to=63.0)
    public abstract float getBasebandCn0DbHz(@IntRange(from=0L) int var1);

    public static abstract class Callback {
        public void onStarted() {
        }

        public void onStopped() {
        }

        public void onFirstFix(@IntRange(from=0L) int ttffMillis) {
        }

        public void onSatelliteStatusChanged(@NonNull GnssStatusCompat status) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ConstellationType {
    }
}

