/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.content.ClipData;
import android.content.ClipDescription;
import android.net.Uri;
import android.os.Bundle;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.core.util.Predicate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public final class ContentInfoCompat {
    public static final int SOURCE_APP = 0;
    public static final int SOURCE_CLIPBOARD = 1;
    public static final int SOURCE_INPUT_METHOD = 2;
    public static final int SOURCE_DRAG_AND_DROP = 3;
    public static final int FLAG_CONVERT_TO_PLAIN_TEXT = 1;
    @NonNull
    final ClipData mClip;
    final int mSource;
    final int mFlags;
    @Nullable
    final Uri mLinkUri;
    @Nullable
    final Bundle mExtras;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NonNull
    static String sourceToString(int source) {
        switch (source) {
            case 0: {
                return "SOURCE_APP";
            }
            case 1: {
                return "SOURCE_CLIPBOARD";
            }
            case 2: {
                return "SOURCE_INPUT_METHOD";
            }
            case 3: {
                return "SOURCE_DRAG_AND_DROP";
            }
        }
        return String.valueOf(source);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NonNull
    static String flagsToString(int flags) {
        if ((flags & 1) != 0) {
            return "FLAG_CONVERT_TO_PLAIN_TEXT";
        }
        return String.valueOf(flags);
    }

    ContentInfoCompat(Builder b) {
        this.mClip = Preconditions.checkNotNull(b.mClip);
        this.mSource = Preconditions.checkArgumentInRange(b.mSource, 0, 3, "source");
        this.mFlags = Preconditions.checkFlagsArgument(b.mFlags, 1);
        this.mLinkUri = b.mLinkUri;
        this.mExtras = b.mExtras;
    }

    @NonNull
    public String toString() {
        return "ContentInfoCompat{clip=" + this.mClip.getDescription() + ", source=" + ContentInfoCompat.sourceToString(this.mSource) + ", flags=" + ContentInfoCompat.flagsToString(this.mFlags) + (this.mLinkUri == null ? "" : ", hasLinkUri(" + this.mLinkUri.toString().length() + ")") + (this.mExtras == null ? "" : ", hasExtras") + "}";
    }

    @NonNull
    public ClipData getClip() {
        return this.mClip;
    }

    public int getSource() {
        return this.mSource;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @Nullable
    public Uri getLinkUri() {
        return this.mLinkUri;
    }

    @Nullable
    public Bundle getExtras() {
        return this.mExtras;
    }

    @NonNull
    public Pair<ContentInfoCompat, ContentInfoCompat> partition(@NonNull Predicate<ClipData.Item> itemPredicate) {
        if (this.mClip.getItemCount() == 1) {
            boolean matched = itemPredicate.test(this.mClip.getItemAt(0));
            return Pair.create((Object)(matched ? this : null), (Object)(matched ? null : this));
        }
        ArrayList<ClipData.Item> acceptedItems = new ArrayList<ClipData.Item>();
        ArrayList<ClipData.Item> remainingItems = new ArrayList<ClipData.Item>();
        for (int i = 0; i < this.mClip.getItemCount(); ++i) {
            ClipData.Item item = this.mClip.getItemAt(i);
            if (itemPredicate.test(item)) {
                acceptedItems.add(item);
                continue;
            }
            remainingItems.add(item);
        }
        if (acceptedItems.isEmpty()) {
            return Pair.create(null, (Object)this);
        }
        if (remainingItems.isEmpty()) {
            return Pair.create((Object)this, null);
        }
        ContentInfoCompat accepted = new Builder(this).setClip(ContentInfoCompat.buildClipData(this.mClip.getDescription(), acceptedItems)).build();
        ContentInfoCompat remaining = new Builder(this).setClip(ContentInfoCompat.buildClipData(this.mClip.getDescription(), remainingItems)).build();
        return Pair.create((Object)accepted, (Object)remaining);
    }

    private static ClipData buildClipData(ClipDescription description, List<ClipData.Item> items) {
        ClipData clip = new ClipData(new ClipDescription(description), items.get(0));
        for (int i = 1; i < items.size(); ++i) {
            clip.addItem(items.get(i));
        }
        return clip;
    }

    public static final class Builder {
        @NonNull
        ClipData mClip;
        int mSource;
        int mFlags;
        @Nullable
        Uri mLinkUri;
        @Nullable
        Bundle mExtras;

        public Builder(@NonNull ContentInfoCompat other) {
            this.mClip = other.mClip;
            this.mSource = other.mSource;
            this.mFlags = other.mFlags;
            this.mLinkUri = other.mLinkUri;
            this.mExtras = other.mExtras;
        }

        public Builder(@NonNull ClipData clip, int source) {
            this.mClip = clip;
            this.mSource = source;
        }

        @NonNull
        public Builder setClip(@NonNull ClipData clip) {
            this.mClip = clip;
            return this;
        }

        @NonNull
        public Builder setSource(int source) {
            this.mSource = source;
            return this;
        }

        @NonNull
        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        @NonNull
        public Builder setLinkUri(@Nullable Uri linkUri) {
            this.mLinkUri = linkUri;
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public ContentInfoCompat build() {
            return new ContentInfoCompat(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Flags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Source {
    }
}

