/*
 * Decompiled with CFR 0.152.
 */
package androidx.dynamicanimation.animation;

import android.util.FloatProperty;
import androidx.annotation.RequiresApi;

public abstract class FloatPropertyCompat<T> {
    final String mPropertyName;

    public FloatPropertyCompat(String name) {
        this.mPropertyName = name;
    }

    @RequiresApi(value=24)
    public static <T> FloatPropertyCompat<T> createFloatPropertyCompat(final FloatProperty<T> property) {
        return new FloatPropertyCompat<T>(property.getName()){

            @Override
            public float getValue(T object) {
                return ((Float)property.get(object)).floatValue();
            }

            @Override
            public void setValue(T object, float value) {
                property.setValue(object, value);
            }
        };
    }

    public abstract float getValue(T var1);

    public abstract void setValue(T var1, float var2);
}

