/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity.result.contract;

import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.IntentSenderRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class ActivityResultContracts {
    private ActivityResultContracts() {
    }

    @TargetApi(value=19)
    public static class CreateDocument
    extends ActivityResultContract<String, Uri> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull String input) {
            return new Intent("android.intent.action.CREATE_DOCUMENT").setType("*/*").putExtra("android.intent.extra.TITLE", input);
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<Uri> getSynchronousResult(@NonNull Context context, @NonNull String input) {
            return null;
        }

        @Override
        @Nullable
        public final Uri parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return null;
            }
            return intent.getData();
        }
    }

    @TargetApi(value=21)
    public static class OpenDocumentTree
    extends ActivityResultContract<Uri, Uri> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @Nullable Uri input) {
            Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
            if (Build.VERSION.SDK_INT >= 26 && input != null) {
                intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)input);
            }
            return intent;
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<Uri> getSynchronousResult(@NonNull Context context, @Nullable Uri input) {
            return null;
        }

        @Override
        @Nullable
        public final Uri parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return null;
            }
            return intent.getData();
        }
    }

    @TargetApi(value=19)
    public static class OpenMultipleDocuments
    extends ActivityResultContract<String[], List<Uri>> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull String[] input) {
            return new Intent("android.intent.action.OPEN_DOCUMENT").putExtra("android.intent.extra.MIME_TYPES", input).putExtra("android.intent.extra.ALLOW_MULTIPLE", true).setType("*/*");
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<List<Uri>> getSynchronousResult(@NonNull Context context, @NonNull String[] input) {
            return null;
        }

        @Override
        @NonNull
        public final List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
            if (resultCode != -1 || intent == null) {
                return Collections.emptyList();
            }
            return GetMultipleContents.getClipDataUris(intent);
        }
    }

    @TargetApi(value=19)
    public static class OpenDocument
    extends ActivityResultContract<String[], Uri> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull String[] input) {
            return new Intent("android.intent.action.OPEN_DOCUMENT").putExtra("android.intent.extra.MIME_TYPES", input).setType("*/*");
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<Uri> getSynchronousResult(@NonNull Context context, @NonNull String[] input) {
            return null;
        }

        @Override
        @Nullable
        public final Uri parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return null;
            }
            return intent.getData();
        }
    }

    @TargetApi(value=18)
    public static class GetMultipleContents
    extends ActivityResultContract<String, List<Uri>> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull String input) {
            return new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").setType(input).putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<List<Uri>> getSynchronousResult(@NonNull Context context, @NonNull String input) {
            return null;
        }

        @Override
        @NonNull
        public final List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return Collections.emptyList();
            }
            return GetMultipleContents.getClipDataUris(intent);
        }

        @NonNull
        static List<Uri> getClipDataUris(@NonNull Intent intent) {
            ClipData clipData;
            LinkedHashSet<Uri> resultSet = new LinkedHashSet<Uri>();
            if (intent.getData() != null) {
                resultSet.add(intent.getData());
            }
            if ((clipData = intent.getClipData()) == null && resultSet.isEmpty()) {
                return Collections.emptyList();
            }
            if (clipData != null) {
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    Uri uri = clipData.getItemAt(i).getUri();
                    if (uri == null) continue;
                    resultSet.add(uri);
                }
            }
            return new ArrayList<Uri>(resultSet);
        }
    }

    public static class GetContent
    extends ActivityResultContract<String, Uri> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull String input) {
            return new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").setType(input);
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<Uri> getSynchronousResult(@NonNull Context context, @NonNull String input) {
            return null;
        }

        @Override
        @Nullable
        public final Uri parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return null;
            }
            return intent.getData();
        }
    }

    public static final class PickContact
    extends ActivityResultContract<Void, Uri> {
        @Override
        @NonNull
        public Intent createIntent(@NonNull Context context, @Nullable Void input) {
            return new Intent("android.intent.action.PICK").setType("vnd.android.cursor.dir/contact");
        }

        @Override
        @Nullable
        public Uri parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return null;
            }
            return intent.getData();
        }
    }

    public static class TakeVideo
    extends ActivityResultContract<Uri, Bitmap> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull Uri input) {
            return new Intent("android.media.action.VIDEO_CAPTURE").putExtra("output", (Parcelable)input);
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<Bitmap> getSynchronousResult(@NonNull Context context, @NonNull Uri input) {
            return null;
        }

        @Override
        @Nullable
        public final Bitmap parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return null;
            }
            return (Bitmap)intent.getParcelableExtra("data");
        }
    }

    public static class TakePicture
    extends ActivityResultContract<Uri, Boolean> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull Uri input) {
            return new Intent("android.media.action.IMAGE_CAPTURE").putExtra("output", (Parcelable)input);
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<Boolean> getSynchronousResult(@NonNull Context context, @NonNull Uri input) {
            return null;
        }

        @Override
        @NonNull
        public final Boolean parseResult(int resultCode, @Nullable Intent intent) {
            return resultCode == -1;
        }
    }

    public static class TakePicturePreview
    extends ActivityResultContract<Void, Bitmap> {
        @Override
        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @Nullable Void input) {
            return new Intent("android.media.action.IMAGE_CAPTURE");
        }

        @Override
        @Nullable
        public final ActivityResultContract.SynchronousResult<Bitmap> getSynchronousResult(@NonNull Context context, @Nullable Void input) {
            return null;
        }

        @Override
        @Nullable
        public final Bitmap parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return null;
            }
            return (Bitmap)intent.getParcelableExtra("data");
        }
    }

    public static final class RequestPermission
    extends ActivityResultContract<String, Boolean> {
        @Override
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull String input) {
            return RequestMultiplePermissions.createIntent(new String[]{input});
        }

        @Override
        @NonNull
        public Boolean parseResult(int resultCode, @Nullable Intent intent) {
            if (intent == null || resultCode != -1) {
                return false;
            }
            int[] grantResults = intent.getIntArrayExtra("androidx.activity.result.contract.extra.PERMISSION_GRANT_RESULTS");
            if (grantResults == null || grantResults.length == 0) {
                return false;
            }
            return grantResults[0] == 0;
        }

        @Override
        @Nullable
        public ActivityResultContract.SynchronousResult<Boolean> getSynchronousResult(@NonNull Context context, @Nullable String input) {
            if (input == null) {
                return new ActivityResultContract.SynchronousResult<Boolean>(false);
            }
            if (ContextCompat.checkSelfPermission((Context)context, (String)input) == 0) {
                return new ActivityResultContract.SynchronousResult<Boolean>(true);
            }
            return null;
        }
    }

    public static final class RequestMultiplePermissions
    extends ActivityResultContract<String[], Map<String, Boolean>> {
        public static final String ACTION_REQUEST_PERMISSIONS = "androidx.activity.result.contract.action.REQUEST_PERMISSIONS";
        public static final String EXTRA_PERMISSIONS = "androidx.activity.result.contract.extra.PERMISSIONS";
        public static final String EXTRA_PERMISSION_GRANT_RESULTS = "androidx.activity.result.contract.extra.PERMISSION_GRANT_RESULTS";

        @Override
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull String[] input) {
            return RequestMultiplePermissions.createIntent(input);
        }

        @Override
        @Nullable
        public ActivityResultContract.SynchronousResult<Map<String, Boolean>> getSynchronousResult(@NonNull Context context, @Nullable String[] input) {
            if (input == null || input.length == 0) {
                return new ActivityResultContract.SynchronousResult<Map<String, Boolean>>(Collections.emptyMap());
            }
            ArrayMap grantState = new ArrayMap();
            boolean allGranted = true;
            for (String permission2 : input) {
                boolean granted = ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
                grantState.put(permission2, granted);
                if (granted) continue;
                allGranted = false;
            }
            if (allGranted) {
                return new ActivityResultContract.SynchronousResult<ArrayMap>(grantState);
            }
            return null;
        }

        @Override
        @NonNull
        public Map<String, Boolean> parseResult(int resultCode, @Nullable Intent intent) {
            if (resultCode != -1) {
                return Collections.emptyMap();
            }
            if (intent == null) {
                return Collections.emptyMap();
            }
            String[] permissions = intent.getStringArrayExtra(EXTRA_PERMISSIONS);
            int[] grantResults = intent.getIntArrayExtra(EXTRA_PERMISSION_GRANT_RESULTS);
            if (grantResults == null || permissions == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            int size = permissions.length;
            for (int i = 0; i < size; ++i) {
                result.put(permissions[i], grantResults[i] == 0);
            }
            return result;
        }

        @NonNull
        static Intent createIntent(@NonNull String[] input) {
            return new Intent(ACTION_REQUEST_PERMISSIONS).putExtra(EXTRA_PERMISSIONS, input);
        }
    }

    public static final class StartIntentSenderForResult
    extends ActivityResultContract<IntentSenderRequest, ActivityResult> {
        public static final String ACTION_INTENT_SENDER_REQUEST = "androidx.activity.result.contract.action.INTENT_SENDER_REQUEST";
        public static final String EXTRA_INTENT_SENDER_REQUEST = "androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST";
        public static final String EXTRA_SEND_INTENT_EXCEPTION = "androidx.activity.result.contract.extra.SEND_INTENT_EXCEPTION";

        @Override
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull IntentSenderRequest input) {
            return new Intent(ACTION_INTENT_SENDER_REQUEST).putExtra(EXTRA_INTENT_SENDER_REQUEST, (Parcelable)input);
        }

        @Override
        @NonNull
        public ActivityResult parseResult(int resultCode, @Nullable Intent intent) {
            return new ActivityResult(resultCode, intent);
        }
    }

    public static final class StartActivityForResult
    extends ActivityResultContract<Intent, ActivityResult> {
        public static final String EXTRA_ACTIVITY_OPTIONS_BUNDLE = "androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE";

        @Override
        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull Intent input) {
            return input;
        }

        @Override
        @NonNull
        public ActivityResult parseResult(int resultCode, @Nullable Intent intent) {
            return new ActivityResult(resultCode, intent);
        }
    }
}

