/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.badge;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.PluralsRes;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.StyleableRes;
import androidx.annotation.XmlRes;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.TextDrawableHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.shape.MaterialShapeDrawable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;

public class BadgeDrawable
extends Drawable
implements TextDrawableHelper.TextDrawableDelegate {
    public static final int TOP_END = 8388661;
    public static final int TOP_START = 0x800033;
    public static final int BOTTOM_END = 0x800055;
    public static final int BOTTOM_START = 8388691;
    private static final int DEFAULT_MAX_BADGE_CHARACTER_COUNT = 4;
    private static final int BADGE_NUMBER_NONE = -1;
    private static final int MAX_CIRCULAR_BADGE_NUMBER_COUNT = 9;
    @StyleRes
    private static final int DEFAULT_STYLE = R.style.Widget_MaterialComponents_Badge;
    @AttrRes
    private static final int DEFAULT_THEME_ATTR = R.attr.badgeStyle;
    static final String DEFAULT_EXCEED_MAX_BADGE_NUMBER_SUFFIX = "+";
    @NonNull
    private final WeakReference<Context> contextRef;
    @NonNull
    private final MaterialShapeDrawable shapeDrawable;
    @NonNull
    private final TextDrawableHelper textDrawableHelper;
    @NonNull
    private final Rect badgeBounds;
    private final float badgeRadius;
    private final float badgeWithTextRadius;
    private final float badgeWidePadding;
    @NonNull
    private final SavedState savedState;
    private float badgeCenterX;
    private float badgeCenterY;
    private int maxBadgeNumber;
    private float cornerRadius;
    private float halfBadgeWidth;
    private float halfBadgeHeight;
    @Nullable
    private WeakReference<View> anchorViewRef;
    @Nullable
    private WeakReference<FrameLayout> customBadgeParentRef;

    @NonNull
    public SavedState getSavedState() {
        return this.savedState;
    }

    @NonNull
    static BadgeDrawable createFromSavedState(@NonNull Context context, @NonNull SavedState savedState) {
        BadgeDrawable badge = new BadgeDrawable(context);
        badge.restoreFromSavedState(savedState);
        return badge;
    }

    @NonNull
    public static BadgeDrawable create(@NonNull Context context) {
        return BadgeDrawable.createFromAttributes(context, null, DEFAULT_THEME_ATTR, DEFAULT_STYLE);
    }

    @NonNull
    public static BadgeDrawable createFromResource(@NonNull Context context, @XmlRes int id2) {
        AttributeSet attrs = DrawableUtils.parseDrawableXml(context, id2, "badge");
        int style2 = attrs.getStyleAttribute();
        if (style2 == 0) {
            style2 = DEFAULT_STYLE;
        }
        return BadgeDrawable.createFromAttributes(context, attrs, DEFAULT_THEME_ATTR, style2);
    }

    @NonNull
    private static BadgeDrawable createFromAttributes(@NonNull Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        BadgeDrawable badge = new BadgeDrawable(context);
        badge.loadDefaultStateFromAttributes(context, attrs, defStyleAttr, defStyleRes);
        return badge;
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible, false);
        this.savedState.isVisible = visible;
        if (BadgeUtils.USE_COMPAT_PARENT && this.getCustomBadgeParent() != null && !visible) {
            ((ViewGroup)this.getCustomBadgeParent().getParent()).invalidate();
        }
    }

    private void restoreFromSavedState(@NonNull SavedState savedState) {
        this.setMaxCharacterCount(savedState.maxCharacterCount);
        if (savedState.number != -1) {
            this.setNumber(savedState.number);
        }
        this.setBackgroundColor(savedState.backgroundColor);
        this.setBadgeTextColor(savedState.badgeTextColor);
        this.setBadgeGravity(savedState.badgeGravity);
        this.setHorizontalOffset(savedState.horizontalOffset);
        this.setVerticalOffset(savedState.verticalOffset);
        this.setAdditionalHorizontalOffset(savedState.additionalHorizontalOffset);
        this.setAdditionalVerticalOffset(savedState.additionalVerticalOffset);
        this.setVisible(savedState.isVisible);
    }

    private void loadDefaultStateFromAttributes(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.Badge, defStyleAttr, defStyleRes, new int[0]);
        this.setMaxCharacterCount(a.getInt(R.styleable.Badge_maxCharacterCount, 4));
        if (a.hasValue(R.styleable.Badge_number)) {
            this.setNumber(a.getInt(R.styleable.Badge_number, 0));
        }
        this.setBackgroundColor(BadgeDrawable.readColorFromAttributes(context, a, R.styleable.Badge_backgroundColor));
        if (a.hasValue(R.styleable.Badge_badgeTextColor)) {
            this.setBadgeTextColor(BadgeDrawable.readColorFromAttributes(context, a, R.styleable.Badge_badgeTextColor));
        }
        this.setBadgeGravity(a.getInt(R.styleable.Badge_badgeGravity, 8388661));
        this.setHorizontalOffset(a.getDimensionPixelOffset(R.styleable.Badge_horizontalOffset, 0));
        this.setVerticalOffset(a.getDimensionPixelOffset(R.styleable.Badge_verticalOffset, 0));
        a.recycle();
    }

    private static int readColorFromAttributes(Context context, @NonNull TypedArray a, @StyleableRes int index) {
        return MaterialResources.getColorStateList(context, a, index).getDefaultColor();
    }

    private BadgeDrawable(@NonNull Context context) {
        this.contextRef = new WeakReference<Context>(context);
        ThemeEnforcement.checkMaterialTheme(context);
        Resources res = context.getResources();
        this.badgeBounds = new Rect();
        this.shapeDrawable = new MaterialShapeDrawable();
        this.badgeRadius = res.getDimensionPixelSize(R.dimen.mtrl_badge_radius);
        this.badgeWidePadding = res.getDimensionPixelSize(R.dimen.mtrl_badge_long_text_horizontal_padding);
        this.badgeWithTextRadius = res.getDimensionPixelSize(R.dimen.mtrl_badge_with_text_radius);
        this.textDrawableHelper = new TextDrawableHelper(this);
        this.textDrawableHelper.getTextPaint().setTextAlign(Paint.Align.CENTER);
        this.savedState = new SavedState(context);
        this.setTextAppearanceResource(R.style.TextAppearance_MaterialComponents_Badge);
    }

    @Deprecated
    public void updateBadgeCoordinates(@NonNull View anchorView, @Nullable ViewGroup customBadgeParent) {
        if (!(customBadgeParent instanceof FrameLayout)) {
            throw new IllegalArgumentException("customBadgeParent must be a FrameLayout");
        }
        this.updateBadgeCoordinates(anchorView, (FrameLayout)customBadgeParent);
    }

    public void updateBadgeCoordinates(@NonNull View anchorView) {
        this.updateBadgeCoordinates(anchorView, (FrameLayout)null);
    }

    public void updateBadgeCoordinates(@NonNull View anchorView, @Nullable FrameLayout customBadgeParent) {
        this.anchorViewRef = new WeakReference<View>(anchorView);
        if (BadgeUtils.USE_COMPAT_PARENT && customBadgeParent == null) {
            this.tryWrapAnchorInCompatParent(anchorView);
        } else {
            this.customBadgeParentRef = new WeakReference<FrameLayout>(customBadgeParent);
        }
        if (!BadgeUtils.USE_COMPAT_PARENT) {
            BadgeDrawable.updateAnchorParentToNotClip(anchorView);
        }
        this.updateCenterAndBounds();
        this.invalidateSelf();
    }

    @Nullable
    public FrameLayout getCustomBadgeParent() {
        return this.customBadgeParentRef != null ? (FrameLayout)this.customBadgeParentRef.get() : null;
    }

    private void tryWrapAnchorInCompatParent(final View anchorView) {
        ViewGroup anchorViewParent = (ViewGroup)anchorView.getParent();
        if (anchorViewParent != null && anchorViewParent.getId() == R.id.mtrl_anchor_parent || this.customBadgeParentRef != null && this.customBadgeParentRef.get() == anchorViewParent) {
            return;
        }
        BadgeDrawable.updateAnchorParentToNotClip(anchorView);
        final FrameLayout frameLayout = new FrameLayout(anchorView.getContext());
        frameLayout.setId(R.id.mtrl_anchor_parent);
        frameLayout.setClipChildren(false);
        frameLayout.setClipToPadding(false);
        frameLayout.setLayoutParams(anchorView.getLayoutParams());
        frameLayout.setMinimumWidth(anchorView.getWidth());
        frameLayout.setMinimumHeight(anchorView.getHeight());
        int anchorIndex = anchorViewParent.indexOfChild(anchorView);
        anchorViewParent.removeViewAt(anchorIndex);
        anchorView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        frameLayout.addView(anchorView);
        anchorViewParent.addView((View)frameLayout, anchorIndex);
        this.customBadgeParentRef = new WeakReference<FrameLayout>(frameLayout);
        frameLayout.post(new Runnable(){

            @Override
            public void run() {
                BadgeDrawable.this.updateBadgeCoordinates(anchorView, frameLayout);
            }
        });
    }

    private static void updateAnchorParentToNotClip(View anchorView) {
        ViewGroup anchorViewParent = (ViewGroup)anchorView.getParent();
        anchorViewParent.setClipChildren(false);
        anchorViewParent.setClipToPadding(false);
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.shapeDrawable.getFillColor().getDefaultColor();
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.savedState.backgroundColor = backgroundColor;
        ColorStateList backgroundColorStateList = ColorStateList.valueOf((int)backgroundColor);
        if (this.shapeDrawable.getFillColor() != backgroundColorStateList) {
            this.shapeDrawable.setFillColor(backgroundColorStateList);
            this.invalidateSelf();
        }
    }

    @ColorInt
    public int getBadgeTextColor() {
        return this.textDrawableHelper.getTextPaint().getColor();
    }

    public void setBadgeTextColor(@ColorInt int badgeTextColor) {
        this.savedState.badgeTextColor = badgeTextColor;
        if (this.textDrawableHelper.getTextPaint().getColor() != badgeTextColor) {
            this.textDrawableHelper.getTextPaint().setColor(badgeTextColor);
            this.invalidateSelf();
        }
    }

    public boolean hasNumber() {
        return this.savedState.number != -1;
    }

    public int getNumber() {
        if (!this.hasNumber()) {
            return 0;
        }
        return this.savedState.number;
    }

    public void setNumber(int number) {
        number = Math.max(0, number);
        if (this.savedState.number != number) {
            this.savedState.number = number;
            this.textDrawableHelper.setTextWidthDirty(true);
            this.updateCenterAndBounds();
            this.invalidateSelf();
        }
    }

    public void clearNumber() {
        this.savedState.number = -1;
        this.invalidateSelf();
    }

    public int getMaxCharacterCount() {
        return this.savedState.maxCharacterCount;
    }

    public void setMaxCharacterCount(int maxCharacterCount) {
        if (this.savedState.maxCharacterCount != maxCharacterCount) {
            this.savedState.maxCharacterCount = maxCharacterCount;
            this.updateMaxBadgeNumber();
            this.textDrawableHelper.setTextWidthDirty(true);
            this.updateCenterAndBounds();
            this.invalidateSelf();
        }
    }

    public int getBadgeGravity() {
        return this.savedState.badgeGravity;
    }

    public void setBadgeGravity(int gravity) {
        if (this.savedState.badgeGravity != gravity) {
            this.savedState.badgeGravity = gravity;
            if (this.anchorViewRef != null && this.anchorViewRef.get() != null) {
                this.updateBadgeCoordinates((View)this.anchorViewRef.get(), this.customBadgeParentRef != null ? (FrameLayout)this.customBadgeParentRef.get() : null);
            }
        }
    }

    public boolean isStateful() {
        return false;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getAlpha() {
        return this.savedState.alpha;
    }

    public void setAlpha(int alpha) {
        this.savedState.alpha = alpha;
        this.textDrawableHelper.getTextPaint().setAlpha(alpha);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicHeight() {
        return this.badgeBounds.height();
    }

    public int getIntrinsicWidth() {
        return this.badgeBounds.width();
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        if (bounds.isEmpty() || this.getAlpha() == 0 || !this.isVisible()) {
            return;
        }
        this.shapeDrawable.draw(canvas);
        if (this.hasNumber()) {
            this.drawText(canvas);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onTextSizeChange() {
        this.invalidateSelf();
    }

    @Override
    public boolean onStateChange(int[] state) {
        return super.onStateChange(state);
    }

    public void setContentDescriptionNumberless(CharSequence charSequence) {
        this.savedState.contentDescriptionNumberless = charSequence;
    }

    public void setContentDescriptionQuantityStringsResource(@PluralsRes int stringsResource) {
        this.savedState.contentDescriptionQuantityStrings = stringsResource;
    }

    public void setContentDescriptionExceedsMaxBadgeNumberStringResource(@StringRes int stringsResource) {
        this.savedState.contentDescriptionExceedsMaxBadgeNumberRes = stringsResource;
    }

    @Nullable
    public CharSequence getContentDescription() {
        if (!this.isVisible()) {
            return null;
        }
        if (this.hasNumber()) {
            if (this.savedState.contentDescriptionQuantityStrings > 0) {
                Context context = (Context)this.contextRef.get();
                if (context == null) {
                    return null;
                }
                if (this.getNumber() <= this.maxBadgeNumber) {
                    return context.getResources().getQuantityString(this.savedState.contentDescriptionQuantityStrings, this.getNumber(), new Object[]{this.getNumber()});
                }
                return context.getString(this.savedState.contentDescriptionExceedsMaxBadgeNumberRes, new Object[]{this.maxBadgeNumber});
            }
            return null;
        }
        return this.savedState.contentDescriptionNumberless;
    }

    public void setHorizontalOffset(int px) {
        this.savedState.horizontalOffset = px;
        this.updateCenterAndBounds();
    }

    public int getHorizontalOffset() {
        return this.savedState.horizontalOffset;
    }

    void setAdditionalHorizontalOffset(int px) {
        this.savedState.additionalHorizontalOffset = px;
        this.updateCenterAndBounds();
    }

    int getAdditionalHorizontalOffset() {
        return this.savedState.additionalHorizontalOffset;
    }

    public void setVerticalOffset(int px) {
        this.savedState.verticalOffset = px;
        this.updateCenterAndBounds();
    }

    public int getVerticalOffset() {
        return this.savedState.verticalOffset;
    }

    void setAdditionalVerticalOffset(int px) {
        this.savedState.additionalVerticalOffset = px;
        this.updateCenterAndBounds();
    }

    int getAdditionalVerticalOffset() {
        return this.savedState.additionalVerticalOffset;
    }

    private void setTextAppearanceResource(@StyleRes int id2) {
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return;
        }
        this.setTextAppearance(new TextAppearance(context, id2));
    }

    private void setTextAppearance(@Nullable TextAppearance textAppearance) {
        if (this.textDrawableHelper.getTextAppearance() == textAppearance) {
            return;
        }
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return;
        }
        this.textDrawableHelper.setTextAppearance(textAppearance, context);
        this.updateCenterAndBounds();
    }

    private void updateCenterAndBounds() {
        FrameLayout customBadgeParent;
        View anchorView;
        Context context = (Context)this.contextRef.get();
        View view = anchorView = this.anchorViewRef != null ? (View)this.anchorViewRef.get() : null;
        if (context == null || anchorView == null) {
            return;
        }
        Rect tmpRect = new Rect();
        tmpRect.set(this.badgeBounds);
        Rect anchorRect = new Rect();
        anchorView.getDrawingRect(anchorRect);
        FrameLayout frameLayout = customBadgeParent = this.customBadgeParentRef != null ? (FrameLayout)this.customBadgeParentRef.get() : null;
        if (customBadgeParent != null || BadgeUtils.USE_COMPAT_PARENT) {
            FrameLayout viewGroup = customBadgeParent == null ? (ViewGroup)anchorView.getParent() : customBadgeParent;
            viewGroup.offsetDescendantRectToMyCoords(anchorView, anchorRect);
        }
        this.calculateCenterAndBounds(context, anchorRect, anchorView);
        BadgeUtils.updateBadgeBounds(this.badgeBounds, this.badgeCenterX, this.badgeCenterY, this.halfBadgeWidth, this.halfBadgeHeight);
        this.shapeDrawable.setCornerSize(this.cornerRadius);
        if (!tmpRect.equals((Object)this.badgeBounds)) {
            this.shapeDrawable.setBounds(this.badgeBounds);
        }
    }

    private void calculateCenterAndBounds(@NonNull Context context, @NonNull Rect anchorRect, @NonNull View anchorView) {
        int totalVerticalOffset = this.savedState.verticalOffset + this.savedState.additionalVerticalOffset;
        switch (this.savedState.badgeGravity) {
            case 8388691: 
            case 0x800055: {
                this.badgeCenterY = anchorRect.bottom - totalVerticalOffset;
                break;
            }
            default: {
                this.badgeCenterY = anchorRect.top + totalVerticalOffset;
            }
        }
        if (this.getNumber() <= 9) {
            this.halfBadgeHeight = this.cornerRadius = !this.hasNumber() ? this.badgeRadius : this.badgeWithTextRadius;
            this.halfBadgeWidth = this.cornerRadius;
        } else {
            this.halfBadgeHeight = this.cornerRadius = this.badgeWithTextRadius;
            String badgeText = this.getBadgeText();
            this.halfBadgeWidth = this.textDrawableHelper.getTextWidth(badgeText) / 2.0f + this.badgeWidePadding;
        }
        int inset = context.getResources().getDimensionPixelSize(this.hasNumber() ? R.dimen.mtrl_badge_text_horizontal_edge_offset : R.dimen.mtrl_badge_horizontal_edge_offset);
        int totalHorizontalOffset = this.savedState.horizontalOffset + this.savedState.additionalHorizontalOffset;
        switch (this.savedState.badgeGravity) {
            case 0x800033: 
            case 8388691: {
                this.badgeCenterX = ViewCompat.getLayoutDirection((View)anchorView) == 0 ? (float)anchorRect.left - this.halfBadgeWidth + (float)inset + (float)totalHorizontalOffset : (float)anchorRect.right + this.halfBadgeWidth - (float)inset - (float)totalHorizontalOffset;
                break;
            }
            default: {
                this.badgeCenterX = ViewCompat.getLayoutDirection((View)anchorView) == 0 ? (float)anchorRect.right + this.halfBadgeWidth - (float)inset - (float)totalHorizontalOffset : (float)anchorRect.left - this.halfBadgeWidth + (float)inset + (float)totalHorizontalOffset;
            }
        }
    }

    private void drawText(Canvas canvas) {
        Rect textBounds = new Rect();
        String badgeText = this.getBadgeText();
        this.textDrawableHelper.getTextPaint().getTextBounds(badgeText, 0, badgeText.length(), textBounds);
        canvas.drawText(badgeText, this.badgeCenterX, this.badgeCenterY + (float)(textBounds.height() / 2), (Paint)this.textDrawableHelper.getTextPaint());
    }

    @NonNull
    private String getBadgeText() {
        if (this.getNumber() <= this.maxBadgeNumber) {
            return NumberFormat.getInstance().format(this.getNumber());
        }
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return "";
        }
        return context.getString(R.string.mtrl_exceed_max_badge_number_suffix, new Object[]{this.maxBadgeNumber, DEFAULT_EXCEED_MAX_BADGE_NUMBER_SUFFIX});
    }

    private void updateMaxBadgeNumber() {
        this.maxBadgeNumber = (int)Math.pow(10.0, (double)this.getMaxCharacterCount() - 1.0) - 1;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class SavedState
    implements Parcelable {
        @ColorInt
        private int backgroundColor;
        @ColorInt
        private int badgeTextColor;
        private int alpha = 255;
        private int number = -1;
        private int maxCharacterCount;
        @Nullable
        private CharSequence contentDescriptionNumberless;
        @PluralsRes
        private int contentDescriptionQuantityStrings;
        @StringRes
        private int contentDescriptionExceedsMaxBadgeNumberRes;
        private int badgeGravity;
        private boolean isVisible;
        @Dimension(unit=1)
        private int horizontalOffset;
        @Dimension(unit=1)
        private int verticalOffset;
        @Dimension(unit=1)
        private int additionalHorizontalOffset;
        @Dimension(unit=1)
        private int additionalVerticalOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(@NonNull Context context) {
            TextAppearance textAppearance = new TextAppearance(context, R.style.TextAppearance_MaterialComponents_Badge);
            this.badgeTextColor = textAppearance.textColor.getDefaultColor();
            this.contentDescriptionNumberless = context.getString(R.string.mtrl_badge_numberless_content_description);
            this.contentDescriptionQuantityStrings = R.plurals.mtrl_badge_content_description;
            this.contentDescriptionExceedsMaxBadgeNumberRes = R.string.mtrl_exceed_max_badge_number_content_description;
            this.isVisible = true;
        }

        protected SavedState(@NonNull Parcel in) {
            this.backgroundColor = in.readInt();
            this.badgeTextColor = in.readInt();
            this.alpha = in.readInt();
            this.number = in.readInt();
            this.maxCharacterCount = in.readInt();
            this.contentDescriptionNumberless = in.readString();
            this.contentDescriptionQuantityStrings = in.readInt();
            this.badgeGravity = in.readInt();
            this.horizontalOffset = in.readInt();
            this.verticalOffset = in.readInt();
            this.additionalHorizontalOffset = in.readInt();
            this.additionalVerticalOffset = in.readInt();
            this.isVisible = in.readInt() != 0;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.backgroundColor);
            dest.writeInt(this.badgeTextColor);
            dest.writeInt(this.alpha);
            dest.writeInt(this.number);
            dest.writeInt(this.maxCharacterCount);
            dest.writeString(this.contentDescriptionNumberless.toString());
            dest.writeInt(this.contentDescriptionQuantityStrings);
            dest.writeInt(this.badgeGravity);
            dest.writeInt(this.horizontalOffset);
            dest.writeInt(this.verticalOffset);
            dest.writeInt(this.additionalHorizontalOffset);
            dest.writeInt(this.additionalVerticalOffset);
            dest.writeInt(this.isVisible ? 1 : 0);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BadgeGravity {
    }
}

