/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.view.AbsSavedState;
import androidx.customview.widget.ViewDragHelper;
import com.google.android.material.R;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BottomSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_EXPANDED = 3;
    public static final int STATE_COLLAPSED = 4;
    public static final int STATE_HIDDEN = 5;
    public static final int STATE_HALF_EXPANDED = 6;
    public static final int PEEK_HEIGHT_AUTO = -1;
    public static final int SAVE_PEEK_HEIGHT = 1;
    public static final int SAVE_FIT_TO_CONTENTS = 2;
    public static final int SAVE_HIDEABLE = 4;
    public static final int SAVE_SKIP_COLLAPSED = 8;
    public static final int SAVE_ALL = -1;
    public static final int SAVE_NONE = 0;
    private static final String TAG = "BottomSheetBehavior";
    private int saveFlags = 0;
    private static final int SIGNIFICANT_VEL_THRESHOLD = 500;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private static final int CORNER_ANIMATION_DURATION = 500;
    private static final int NO_WIDTH = -1;
    private boolean fitToContents = true;
    private boolean updateImportantForAccessibilityOnSiblings = false;
    private float maximumVelocity;
    private int peekHeight;
    private boolean peekHeightAuto;
    private int peekHeightMin;
    private int peekHeightGestureInsetBuffer;
    private boolean shapeThemingEnabled;
    private MaterialShapeDrawable materialShapeDrawable;
    private int maxWidth = -1;
    private int gestureInsetBottom;
    private boolean gestureInsetBottomIgnored;
    private boolean paddingBottomSystemWindowInsets;
    private boolean paddingLeftSystemWindowInsets;
    private boolean paddingRightSystemWindowInsets;
    private boolean paddingTopSystemWindowInsets;
    private int insetBottom;
    private int insetTop;
    private ShapeAppearanceModel shapeAppearanceModelDefault;
    private boolean isShapeExpanded;
    private SettleRunnable settleRunnable = null;
    @Nullable
    private ValueAnimator interpolatorAnimator;
    private static final int DEF_STYLE_RES = R.style.Widget_Design_BottomSheet_Modal;
    int expandedOffset;
    int fitToContentsOffset;
    int halfExpandedOffset;
    float halfExpandedRatio = 0.5f;
    int collapsedOffset;
    float elevation = -1.0f;
    boolean hideable;
    private boolean skipCollapsed;
    private boolean draggable = true;
    int state = 4;
    @Nullable
    ViewDragHelper viewDragHelper;
    private boolean ignoreEvents;
    private int lastNestedScrollDy;
    private boolean nestedScrolled;
    private int childHeight;
    int parentWidth;
    int parentHeight;
    @Nullable
    WeakReference<V> viewRef;
    @Nullable
    WeakReference<View> nestedScrollingChildRef;
    @NonNull
    private final ArrayList<BottomSheetCallback> callbacks = new ArrayList();
    @Nullable
    private VelocityTracker velocityTracker;
    int activePointerId;
    private int initialY;
    boolean touchingScrollingChild;
    @Nullable
    private Map<View, Integer> importantForAccessibilityMap;
    private int expandHalfwayActionId = -1;
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(@NonNull View child, int pointerId) {
            if (BottomSheetBehavior.this.state == 1) {
                return false;
            }
            if (BottomSheetBehavior.this.touchingScrollingChild) {
                return false;
            }
            if (BottomSheetBehavior.this.state == 3 && BottomSheetBehavior.this.activePointerId == pointerId) {
                View scroll;
                View view = scroll = BottomSheetBehavior.this.nestedScrollingChildRef != null ? (View)BottomSheetBehavior.this.nestedScrollingChildRef.get() : null;
                if (scroll != null && scroll.canScrollVertically(-1)) {
                    return false;
                }
            }
            return BottomSheetBehavior.this.viewRef != null && BottomSheetBehavior.this.viewRef.get() == child;
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            BottomSheetBehavior.this.dispatchOnSlide(top);
        }

        public void onViewDragStateChanged(int state) {
            if (state == 1 && BottomSheetBehavior.this.draggable) {
                BottomSheetBehavior.this.setStateInternal(1);
            }
        }

        private boolean releasedLow(@NonNull View child) {
            return child.getTop() > (BottomSheetBehavior.this.parentHeight + BottomSheetBehavior.this.getExpandedOffset()) / 2;
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            int targetState;
            int top;
            if (yvel < 0.0f) {
                if (BottomSheetBehavior.this.fitToContents) {
                    top = BottomSheetBehavior.this.fitToContentsOffset;
                    targetState = 3;
                } else {
                    int currentTop = releasedChild.getTop();
                    if (currentTop > BottomSheetBehavior.this.halfExpandedOffset) {
                        top = BottomSheetBehavior.this.halfExpandedOffset;
                        targetState = 6;
                    } else {
                        top = BottomSheetBehavior.this.getExpandedOffset();
                        targetState = 3;
                    }
                }
            } else if (BottomSheetBehavior.this.hideable && BottomSheetBehavior.this.shouldHide(releasedChild, yvel)) {
                if (Math.abs(xvel) < Math.abs(yvel) && yvel > 500.0f || this.releasedLow(releasedChild)) {
                    top = BottomSheetBehavior.this.parentHeight;
                    targetState = 5;
                } else if (BottomSheetBehavior.this.fitToContents) {
                    top = BottomSheetBehavior.this.fitToContentsOffset;
                    targetState = 3;
                } else if (Math.abs(releasedChild.getTop() - BottomSheetBehavior.this.getExpandedOffset()) < Math.abs(releasedChild.getTop() - BottomSheetBehavior.this.halfExpandedOffset)) {
                    top = BottomSheetBehavior.this.getExpandedOffset();
                    targetState = 3;
                } else {
                    top = BottomSheetBehavior.this.halfExpandedOffset;
                    targetState = 6;
                }
            } else if (yvel == 0.0f || Math.abs(xvel) > Math.abs(yvel)) {
                int currentTop = releasedChild.getTop();
                if (BottomSheetBehavior.this.fitToContents) {
                    if (Math.abs(currentTop - BottomSheetBehavior.this.fitToContentsOffset) < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset)) {
                        top = BottomSheetBehavior.this.fitToContentsOffset;
                        targetState = 3;
                    } else {
                        top = BottomSheetBehavior.this.collapsedOffset;
                        targetState = 4;
                    }
                } else if (currentTop < BottomSheetBehavior.this.halfExpandedOffset) {
                    if (currentTop < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset)) {
                        top = BottomSheetBehavior.this.getExpandedOffset();
                        targetState = 3;
                    } else {
                        top = BottomSheetBehavior.this.halfExpandedOffset;
                        targetState = 6;
                    }
                } else if (Math.abs(currentTop - BottomSheetBehavior.this.halfExpandedOffset) < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset)) {
                    top = BottomSheetBehavior.this.halfExpandedOffset;
                    targetState = 6;
                } else {
                    top = BottomSheetBehavior.this.collapsedOffset;
                    targetState = 4;
                }
            } else if (BottomSheetBehavior.this.fitToContents) {
                top = BottomSheetBehavior.this.collapsedOffset;
                targetState = 4;
            } else {
                int currentTop = releasedChild.getTop();
                if (Math.abs(currentTop - BottomSheetBehavior.this.halfExpandedOffset) < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset)) {
                    top = BottomSheetBehavior.this.halfExpandedOffset;
                    targetState = 6;
                } else {
                    top = BottomSheetBehavior.this.collapsedOffset;
                    targetState = 4;
                }
            }
            BottomSheetBehavior.this.startSettlingAnimation(releasedChild, targetState, top, true);
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            return MathUtils.clamp((int)top, (int)BottomSheetBehavior.this.getExpandedOffset(), (int)(BottomSheetBehavior.this.hideable ? BottomSheetBehavior.this.parentHeight : BottomSheetBehavior.this.collapsedOffset));
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            return child.getLeft();
        }

        public int getViewVerticalDragRange(@NonNull View child) {
            if (BottomSheetBehavior.this.hideable) {
                return BottomSheetBehavior.this.parentHeight;
            }
            return BottomSheetBehavior.this.collapsedOffset;
        }
    };

    public BottomSheetBehavior() {
    }

    public BottomSheetBehavior(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedValue value;
        this.peekHeightGestureInsetBuffer = context.getResources().getDimensionPixelSize(R.dimen.mtrl_min_touch_target_size);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BottomSheetBehavior_Layout);
        this.shapeThemingEnabled = a.hasValue(R.styleable.BottomSheetBehavior_Layout_shapeAppearance);
        boolean hasBackgroundTint = a.hasValue(R.styleable.BottomSheetBehavior_Layout_backgroundTint);
        if (hasBackgroundTint) {
            ColorStateList bottomSheetColor = MaterialResources.getColorStateList(context, a, R.styleable.BottomSheetBehavior_Layout_backgroundTint);
            this.createMaterialShapeDrawable(context, attrs, hasBackgroundTint, bottomSheetColor);
        } else {
            this.createMaterialShapeDrawable(context, attrs, hasBackgroundTint);
        }
        this.createShapeValueAnimator();
        if (Build.VERSION.SDK_INT >= 21) {
            this.elevation = a.getDimension(R.styleable.BottomSheetBehavior_Layout_android_elevation, -1.0f);
        }
        if (a.hasValue(R.styleable.BottomSheetBehavior_Layout_android_maxWidth)) {
            this.setMaxWidth(a.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_android_maxWidth, -1));
        }
        if ((value = a.peekValue(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight)) != null && value.data == -1) {
            this.setPeekHeight(value.data);
        } else {
            this.setPeekHeight(a.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, -1));
        }
        this.setHideable(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false));
        this.setGestureInsetBottomIgnored(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_gestureInsetBottomIgnored, false));
        this.setFitToContents(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_fitToContents, true));
        this.setSkipCollapsed(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_skipCollapsed, false));
        this.setDraggable(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_draggable, true));
        this.setSaveFlags(a.getInt(R.styleable.BottomSheetBehavior_Layout_behavior_saveFlags, 0));
        this.setHalfExpandedRatio(a.getFloat(R.styleable.BottomSheetBehavior_Layout_behavior_halfExpandedRatio, 0.5f));
        value = a.peekValue(R.styleable.BottomSheetBehavior_Layout_behavior_expandedOffset);
        if (value != null && value.type == 16) {
            this.setExpandedOffset(value.data);
        } else {
            this.setExpandedOffset(a.getDimensionPixelOffset(R.styleable.BottomSheetBehavior_Layout_behavior_expandedOffset, 0));
        }
        this.paddingBottomSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingBottomSystemWindowInsets, false);
        this.paddingLeftSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingLeftSystemWindowInsets, false);
        this.paddingRightSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingRightSystemWindowInsets, false);
        this.paddingTopSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingTopSystemWindowInsets, true);
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    @NonNull
    public Parcelable onSaveInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child) {
        return new SavedState(super.onSaveInstanceState(parent, child), this);
    }

    public void onRestoreInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(parent, child, ss.getSuperState());
        this.restoreOptionalState(ss);
        this.state = ss.state == 1 || ss.state == 2 ? 4 : ss.state;
    }

    public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams layoutParams) {
        super.onAttachedToLayoutParams(layoutParams);
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public void onDetachedFromLayoutParams() {
        super.onDetachedFromLayoutParams();
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull V child, int layoutDirection) {
        if (ViewCompat.getFitsSystemWindows((View)parent) && !ViewCompat.getFitsSystemWindows(child)) {
            child.setFitsSystemWindows(true);
        }
        if (this.viewRef == null) {
            int width;
            this.peekHeightMin = parent.getResources().getDimensionPixelSize(R.dimen.design_bottom_sheet_peek_height_min);
            this.setWindowInsetsListener((View)child);
            this.viewRef = new WeakReference<V>(child);
            if (this.shapeThemingEnabled && this.materialShapeDrawable != null) {
                ViewCompat.setBackground(child, (Drawable)this.materialShapeDrawable);
            }
            if (this.materialShapeDrawable != null) {
                this.materialShapeDrawable.setElevation(this.elevation == -1.0f ? ViewCompat.getElevation(child) : this.elevation);
                this.isShapeExpanded = this.state == 3;
                this.materialShapeDrawable.setInterpolation(this.isShapeExpanded ? 0.0f : 1.0f);
            }
            this.updateAccessibilityActions();
            if (ViewCompat.getImportantForAccessibility(child) == 0) {
                ViewCompat.setImportantForAccessibility(child, (int)1);
            }
            if ((width = child.getMeasuredWidth()) > this.maxWidth && this.maxWidth != -1) {
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                lp.width = this.maxWidth;
                child.post(new Runnable((View)child, lp){
                    final /* synthetic */ View val$child;
                    final /* synthetic */ ViewGroup.LayoutParams val$lp;
                    {
                        this.val$child = view;
                        this.val$lp = layoutParams;
                    }

                    @Override
                    public void run() {
                        this.val$child.setLayoutParams(this.val$lp);
                    }
                });
            }
        }
        if (this.viewDragHelper == null) {
            this.viewDragHelper = ViewDragHelper.create((ViewGroup)parent, (ViewDragHelper.Callback)this.dragCallback);
        }
        int savedTop = child.getTop();
        parent.onLayoutChild(child, layoutDirection);
        this.parentWidth = parent.getWidth();
        this.parentHeight = parent.getHeight();
        this.childHeight = child.getHeight();
        if (this.parentHeight - this.childHeight < this.insetTop) {
            this.childHeight = this.paddingTopSystemWindowInsets ? this.parentHeight : this.parentHeight - this.insetTop;
        }
        this.fitToContentsOffset = Math.max(0, this.parentHeight - this.childHeight);
        this.calculateHalfExpandedOffset();
        this.calculateCollapsedOffset();
        if (this.state == 3) {
            ViewCompat.offsetTopAndBottom(child, (int)this.getExpandedOffset());
        } else if (this.state == 6) {
            ViewCompat.offsetTopAndBottom(child, (int)this.halfExpandedOffset);
        } else if (this.hideable && this.state == 5) {
            ViewCompat.offsetTopAndBottom(child, (int)this.parentHeight);
        } else if (this.state == 4) {
            ViewCompat.offsetTopAndBottom(child, (int)this.collapsedOffset);
        } else if (this.state == 1 || this.state == 2) {
            ViewCompat.offsetTopAndBottom(child, (int)(savedTop - child.getTop()));
        }
        this.nestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)child));
        return true;
    }

    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown() || !this.draggable) {
            this.ignoreEvents = true;
            return false;
        }
        int action = event.getActionMasked();
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        switch (action) {
            case 1: 
            case 3: {
                this.touchingScrollingChild = false;
                this.activePointerId = -1;
                if (!this.ignoreEvents) break;
                this.ignoreEvents = false;
                return false;
            }
            case 0: {
                int initialX = (int)event.getX();
                this.initialY = (int)event.getY();
                if (this.state != 2) {
                    View scroll;
                    View view = scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
                    if (scroll != null && parent.isPointInChildBounds(scroll, initialX, this.initialY)) {
                        this.activePointerId = event.getPointerId(event.getActionIndex());
                        this.touchingScrollingChild = true;
                    }
                }
                this.ignoreEvents = this.activePointerId == -1 && !parent.isPointInChildBounds(child, initialX, this.initialY);
                break;
            }
        }
        if (!this.ignoreEvents && this.viewDragHelper != null && this.viewDragHelper.shouldInterceptTouchEvent(event)) {
            return true;
        }
        View scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        return action == 2 && scroll != null && !this.ignoreEvents && this.state != 1 && !parent.isPointInChildBounds(scroll, (int)event.getX(), (int)event.getY()) && this.viewDragHelper != null && Math.abs((float)this.initialY - event.getY()) > (float)this.viewDragHelper.getTouchSlop();
    }

    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.state == 1 && action == 0) {
            return true;
        }
        if (this.viewDragHelper != null) {
            this.viewDragHelper.processTouchEvent(event);
        }
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        if (this.viewDragHelper != null && action == 2 && !this.ignoreEvents && Math.abs((float)this.initialY - event.getY()) > (float)this.viewDragHelper.getTouchSlop()) {
            this.viewDragHelper.captureChildView(child, event.getPointerId(event.getActionIndex()));
        }
        return !this.ignoreEvents;
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        this.lastNestedScrollDy = 0;
        this.nestedScrolled = false;
        return (axes & 2) != 0;
    }

    public void onNestedPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        View scrollingChild;
        if (type == 1) {
            return;
        }
        View view = scrollingChild = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        if (target != scrollingChild) {
            return;
        }
        int currentTop = child.getTop();
        int newTop = currentTop - dy;
        if (dy > 0) {
            if (newTop < this.getExpandedOffset()) {
                consumed[1] = currentTop - this.getExpandedOffset();
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(3);
            } else {
                if (!this.draggable) {
                    return;
                }
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            }
        } else if (dy < 0 && !target.canScrollVertically(-1)) {
            if (newTop <= this.collapsedOffset || this.hideable) {
                if (!this.draggable) {
                    return;
                }
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            } else {
                consumed[1] = currentTop - this.collapsedOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(4);
            }
        }
        this.dispatchOnSlide(child.getTop());
        this.lastNestedScrollDy = dy;
        this.nestedScrolled = true;
    }

    public void onStopNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int type) {
        int targetState;
        int top;
        if (child.getTop() == this.getExpandedOffset()) {
            this.setStateInternal(3);
            return;
        }
        if (this.nestedScrollingChildRef == null || target != this.nestedScrollingChildRef.get() || !this.nestedScrolled) {
            return;
        }
        if (this.lastNestedScrollDy > 0) {
            if (this.fitToContents) {
                top = this.fitToContentsOffset;
                targetState = 3;
            } else {
                int currentTop = child.getTop();
                if (currentTop > this.halfExpandedOffset) {
                    top = this.halfExpandedOffset;
                    targetState = 6;
                } else {
                    top = this.getExpandedOffset();
                    targetState = 3;
                }
            }
        } else if (this.hideable && this.shouldHide((View)child, this.getYVelocity())) {
            top = this.parentHeight;
            targetState = 5;
        } else if (this.lastNestedScrollDy == 0) {
            int currentTop = child.getTop();
            if (this.fitToContents) {
                if (Math.abs(currentTop - this.fitToContentsOffset) < Math.abs(currentTop - this.collapsedOffset)) {
                    top = this.fitToContentsOffset;
                    targetState = 3;
                } else {
                    top = this.collapsedOffset;
                    targetState = 4;
                }
            } else if (currentTop < this.halfExpandedOffset) {
                if (currentTop < Math.abs(currentTop - this.collapsedOffset)) {
                    top = this.getExpandedOffset();
                    targetState = 3;
                } else {
                    top = this.halfExpandedOffset;
                    targetState = 6;
                }
            } else if (Math.abs(currentTop - this.halfExpandedOffset) < Math.abs(currentTop - this.collapsedOffset)) {
                top = this.halfExpandedOffset;
                targetState = 6;
            } else {
                top = this.collapsedOffset;
                targetState = 4;
            }
        } else if (this.fitToContents) {
            top = this.collapsedOffset;
            targetState = 4;
        } else {
            int currentTop = child.getTop();
            if (Math.abs(currentTop - this.halfExpandedOffset) < Math.abs(currentTop - this.collapsedOffset)) {
                top = this.halfExpandedOffset;
                targetState = 6;
            } else {
                top = this.collapsedOffset;
                targetState = 4;
            }
        }
        this.startSettlingAnimation((View)child, targetState, top, false);
        this.nestedScrolled = false;
    }

    public void onNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
    }

    public boolean onNestedPreFling(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, float velocityX, float velocityY) {
        if (this.nestedScrollingChildRef != null) {
            return target == this.nestedScrollingChildRef.get() && (this.state != 3 || super.onNestedPreFling(coordinatorLayout, child, target, velocityX, velocityY));
        }
        return false;
    }

    public boolean isFitToContents() {
        return this.fitToContents;
    }

    public void setFitToContents(boolean fitToContents) {
        if (this.fitToContents == fitToContents) {
            return;
        }
        this.fitToContents = fitToContents;
        if (this.viewRef != null) {
            this.calculateCollapsedOffset();
        }
        this.setStateInternal(this.fitToContents && this.state == 6 ? 3 : this.state);
        this.updateAccessibilityActions();
    }

    public void setMaxWidth(@Px int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Px
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setPeekHeight(int peekHeight) {
        this.setPeekHeight(peekHeight, false);
    }

    public final void setPeekHeight(int peekHeight, boolean animate) {
        boolean layout2 = false;
        if (peekHeight == -1) {
            if (!this.peekHeightAuto) {
                this.peekHeightAuto = true;
                layout2 = true;
            }
        } else if (this.peekHeightAuto || this.peekHeight != peekHeight) {
            this.peekHeightAuto = false;
            this.peekHeight = Math.max(0, peekHeight);
            layout2 = true;
        }
        if (layout2) {
            this.updatePeekHeight(animate);
        }
    }

    private void updatePeekHeight(boolean animate) {
        if (this.viewRef != null) {
            View view;
            this.calculateCollapsedOffset();
            if (this.state == 4 && (view = (View)this.viewRef.get()) != null) {
                if (animate) {
                    this.settleToStatePendingLayout(this.state);
                } else {
                    view.requestLayout();
                }
            }
        }
    }

    public int getPeekHeight() {
        return this.peekHeightAuto ? -1 : this.peekHeight;
    }

    public void setHalfExpandedRatio(@FloatRange(from=0.0, to=1.0) float ratio) {
        if (ratio <= 0.0f || ratio >= 1.0f) {
            throw new IllegalArgumentException("ratio must be a float value between 0 and 1");
        }
        this.halfExpandedRatio = ratio;
        if (this.viewRef != null) {
            this.calculateHalfExpandedOffset();
        }
    }

    @FloatRange(from=0.0, to=1.0)
    public float getHalfExpandedRatio() {
        return this.halfExpandedRatio;
    }

    public void setExpandedOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be greater than or equal to 0");
        }
        this.expandedOffset = offset;
    }

    public int getExpandedOffset() {
        return this.fitToContents ? this.fitToContentsOffset : Math.max(this.expandedOffset, this.paddingTopSystemWindowInsets ? 0 : this.insetTop);
    }

    public void setHideable(boolean hideable) {
        if (this.hideable != hideable) {
            this.hideable = hideable;
            if (!hideable && this.state == 5) {
                this.setState(4);
            }
            this.updateAccessibilityActions();
        }
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public void setSkipCollapsed(boolean skipCollapsed) {
        this.skipCollapsed = skipCollapsed;
    }

    public boolean getSkipCollapsed() {
        return this.skipCollapsed;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setSaveFlags(int flags) {
        this.saveFlags = flags;
    }

    public int getSaveFlags() {
        return this.saveFlags;
    }

    @Deprecated
    public void setBottomSheetCallback(BottomSheetCallback callback) {
        Log.w((String)TAG, (String)"BottomSheetBehavior now supports multiple callbacks. `setBottomSheetCallback()` removes all existing callbacks, including ones set internally by library authors, which may result in unintended behavior. This may change in the future. Please use `addBottomSheetCallback()` and `removeBottomSheetCallback()` instead to set your own callbacks.");
        this.callbacks.clear();
        if (callback != null) {
            this.callbacks.add(callback);
        }
    }

    public void addBottomSheetCallback(@NonNull BottomSheetCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public void removeBottomSheetCallback(@NonNull BottomSheetCallback callback) {
        this.callbacks.remove(callback);
    }

    public void setState(int state) {
        if (state == this.state) {
            return;
        }
        if (this.viewRef == null) {
            if (state == 4 || state == 3 || state == 6 || this.hideable && state == 5) {
                this.state = state;
            }
            return;
        }
        this.settleToStatePendingLayout(state);
    }

    public void setGestureInsetBottomIgnored(boolean gestureInsetBottomIgnored) {
        this.gestureInsetBottomIgnored = gestureInsetBottomIgnored;
    }

    public boolean isGestureInsetBottomIgnored() {
        return this.gestureInsetBottomIgnored;
    }

    private void settleToStatePendingLayout(int state) {
        final View child = (View)this.viewRef.get();
        if (child == null) {
            return;
        }
        ViewParent parent = child.getParent();
        if (parent != null && parent.isLayoutRequested() && ViewCompat.isAttachedToWindow((View)child)) {
            final int finalState = state;
            child.post(new Runnable(){

                @Override
                public void run() {
                    BottomSheetBehavior.this.settleToState(child, finalState);
                }
            });
        } else {
            this.settleToState(child, state);
        }
    }

    public int getState() {
        return this.state;
    }

    void setStateInternal(int state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        if (this.viewRef == null) {
            return;
        }
        View bottomSheet = (View)this.viewRef.get();
        if (bottomSheet == null) {
            return;
        }
        if (state == 3) {
            this.updateImportantForAccessibility(true);
        } else if (state == 6 || state == 5 || state == 4) {
            this.updateImportantForAccessibility(false);
        }
        this.updateDrawableForTargetState(state);
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onStateChanged(bottomSheet, state);
        }
        this.updateAccessibilityActions();
    }

    private void updateDrawableForTargetState(int state) {
        boolean expand;
        if (state == 2) {
            return;
        }
        boolean bl = expand = state == 3;
        if (this.isShapeExpanded != expand) {
            this.isShapeExpanded = expand;
            if (this.materialShapeDrawable != null && this.interpolatorAnimator != null) {
                if (this.interpolatorAnimator.isRunning()) {
                    this.interpolatorAnimator.reverse();
                } else {
                    float to = expand ? 0.0f : 1.0f;
                    float from = 1.0f - to;
                    this.interpolatorAnimator.setFloatValues(new float[]{from, to});
                    this.interpolatorAnimator.start();
                }
            }
        }
    }

    private int calculatePeekHeight() {
        if (this.peekHeightAuto) {
            int desiredHeight = Math.max(this.peekHeightMin, this.parentHeight - this.parentWidth * 9 / 16);
            return Math.min(desiredHeight, this.childHeight) + this.insetBottom;
        }
        if (!this.gestureInsetBottomIgnored && !this.paddingBottomSystemWindowInsets && this.gestureInsetBottom > 0) {
            return Math.max(this.peekHeight, this.gestureInsetBottom + this.peekHeightGestureInsetBuffer);
        }
        return this.peekHeight + this.insetBottom;
    }

    private void calculateCollapsedOffset() {
        int peek = this.calculatePeekHeight();
        this.collapsedOffset = this.fitToContents ? Math.max(this.parentHeight - peek, this.fitToContentsOffset) : this.parentHeight - peek;
    }

    private void calculateHalfExpandedOffset() {
        this.halfExpandedOffset = (int)((float)this.parentHeight * (1.0f - this.halfExpandedRatio));
    }

    private void reset() {
        this.activePointerId = -1;
        if (this.velocityTracker != null) {
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }

    private void restoreOptionalState(@NonNull SavedState ss) {
        if (this.saveFlags == 0) {
            return;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 1) == 1) {
            this.peekHeight = ss.peekHeight;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 2) == 2) {
            this.fitToContents = ss.fitToContents;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 4) == 4) {
            this.hideable = ss.hideable;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 8) == 8) {
            this.skipCollapsed = ss.skipCollapsed;
        }
    }

    boolean shouldHide(@NonNull View child, float yvel) {
        if (this.skipCollapsed) {
            return true;
        }
        if (child.getTop() < this.collapsedOffset) {
            return false;
        }
        int peek = this.calculatePeekHeight();
        float newTop = (float)child.getTop() + yvel * 0.1f;
        return Math.abs(newTop - (float)this.collapsedOffset) / (float)peek > 0.5f;
    }

    @Nullable
    @VisibleForTesting
    View findScrollingChild(View view) {
        if (ViewCompat.isNestedScrollingEnabled((View)view)) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View scrollingChild = this.findScrollingChild(group.getChildAt(i));
                if (scrollingChild == null) continue;
                return scrollingChild;
            }
        }
        return null;
    }

    private void createMaterialShapeDrawable(@NonNull Context context, AttributeSet attrs, boolean hasBackgroundTint) {
        this.createMaterialShapeDrawable(context, attrs, hasBackgroundTint, null);
    }

    private void createMaterialShapeDrawable(@NonNull Context context, AttributeSet attrs, boolean hasBackgroundTint, @Nullable ColorStateList bottomSheetColor) {
        if (this.shapeThemingEnabled) {
            this.shapeAppearanceModelDefault = ShapeAppearanceModel.builder(context, attrs, R.attr.bottomSheetStyle, DEF_STYLE_RES).build();
            this.materialShapeDrawable = new MaterialShapeDrawable(this.shapeAppearanceModelDefault);
            this.materialShapeDrawable.initializeElevationOverlay(context);
            if (hasBackgroundTint && bottomSheetColor != null) {
                this.materialShapeDrawable.setFillColor(bottomSheetColor);
            } else {
                TypedValue defaultColor = new TypedValue();
                context.getTheme().resolveAttribute(0x1010031, defaultColor, true);
                this.materialShapeDrawable.setTint(defaultColor.data);
            }
        }
    }

    MaterialShapeDrawable getMaterialShapeDrawable() {
        return this.materialShapeDrawable;
    }

    private void createShapeValueAnimator() {
        this.interpolatorAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.interpolatorAnimator.setDuration(500L);
        this.interpolatorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                if (BottomSheetBehavior.this.materialShapeDrawable != null) {
                    BottomSheetBehavior.this.materialShapeDrawable.setInterpolation(value);
                }
            }
        });
    }

    private void setWindowInsetsListener(@NonNull View child) {
        boolean shouldHandleGestureInsets;
        boolean bl = shouldHandleGestureInsets = Build.VERSION.SDK_INT >= 29 && !this.isGestureInsetBottomIgnored() && !this.peekHeightAuto;
        if (!(this.paddingBottomSystemWindowInsets || this.paddingLeftSystemWindowInsets || this.paddingRightSystemWindowInsets || shouldHandleGestureInsets)) {
            return;
        }
        ViewUtils.doOnApplyWindowInsets(child, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat insets, ViewUtils.RelativePadding initialPadding) {
                BottomSheetBehavior.this.insetTop = insets.getSystemWindowInsetTop();
                boolean isRtl = ViewUtils.isLayoutRtl(view);
                int bottomPadding = view.getPaddingBottom();
                int leftPadding = view.getPaddingLeft();
                int rightPadding = view.getPaddingRight();
                if (BottomSheetBehavior.this.paddingBottomSystemWindowInsets) {
                    BottomSheetBehavior.this.insetBottom = insets.getSystemWindowInsetBottom();
                    bottomPadding = initialPadding.bottom + BottomSheetBehavior.this.insetBottom;
                }
                if (BottomSheetBehavior.this.paddingLeftSystemWindowInsets) {
                    leftPadding = isRtl ? initialPadding.end : initialPadding.start;
                    leftPadding += insets.getSystemWindowInsetLeft();
                }
                if (BottomSheetBehavior.this.paddingRightSystemWindowInsets) {
                    rightPadding = isRtl ? initialPadding.start : initialPadding.end;
                    rightPadding += insets.getSystemWindowInsetRight();
                }
                view.setPadding(leftPadding, view.getPaddingTop(), rightPadding, bottomPadding);
                if (shouldHandleGestureInsets) {
                    BottomSheetBehavior.this.gestureInsetBottom = insets.getMandatorySystemGestureInsets().bottom;
                }
                if (BottomSheetBehavior.this.paddingBottomSystemWindowInsets || shouldHandleGestureInsets) {
                    BottomSheetBehavior.this.updatePeekHeight(false);
                }
                return insets;
            }
        });
    }

    private float getYVelocity() {
        if (this.velocityTracker == null) {
            return 0.0f;
        }
        this.velocityTracker.computeCurrentVelocity(1000, this.maximumVelocity);
        return this.velocityTracker.getYVelocity(this.activePointerId);
    }

    void settleToState(@NonNull View child, int state) {
        int top;
        if (state == 4) {
            top = this.collapsedOffset;
        } else if (state == 6) {
            top = this.halfExpandedOffset;
            if (this.fitToContents && top <= this.fitToContentsOffset) {
                state = 3;
                top = this.fitToContentsOffset;
            }
        } else if (state == 3) {
            top = this.getExpandedOffset();
        } else if (this.hideable && state == 5) {
            top = this.parentHeight;
        } else {
            throw new IllegalArgumentException("Illegal state argument: " + state);
        }
        this.startSettlingAnimation(child, state, top, false);
    }

    void startSettlingAnimation(View child, int state, int top, boolean settleFromViewDragHelper) {
        boolean startedSettling;
        boolean bl = this.viewDragHelper != null && (settleFromViewDragHelper ? this.viewDragHelper.settleCapturedViewAt(child.getLeft(), top) : this.viewDragHelper.smoothSlideViewTo(child, child.getLeft(), top)) ? true : (startedSettling = false);
        if (startedSettling) {
            this.setStateInternal(2);
            this.updateDrawableForTargetState(state);
            if (this.settleRunnable == null) {
                this.settleRunnable = new SettleRunnable(child, state);
            }
            if (!this.settleRunnable.isPosted) {
                this.settleRunnable.targetState = state;
                ViewCompat.postOnAnimation((View)child, (Runnable)this.settleRunnable);
                this.settleRunnable.isPosted = true;
            } else {
                this.settleRunnable.targetState = state;
            }
        } else {
            this.setStateInternal(state);
        }
    }

    void dispatchOnSlide(int top) {
        View bottomSheet = (View)this.viewRef.get();
        if (bottomSheet != null && !this.callbacks.isEmpty()) {
            float slideOffset = top > this.collapsedOffset || this.collapsedOffset == this.getExpandedOffset() ? (float)(this.collapsedOffset - top) / (float)(this.parentHeight - this.collapsedOffset) : (float)(this.collapsedOffset - top) / (float)(this.collapsedOffset - this.getExpandedOffset());
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).onSlide(bottomSheet, slideOffset);
            }
        }
    }

    @VisibleForTesting
    int getPeekHeightMin() {
        return this.peekHeightMin;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    public void disableShapeAnimations() {
        this.interpolatorAnimator = null;
    }

    @NonNull
    public static <V extends View> BottomSheetBehavior<V> from(@NonNull V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof BottomSheetBehavior)) {
            throw new IllegalArgumentException("The view is not associated with BottomSheetBehavior");
        }
        return (BottomSheetBehavior)behavior;
    }

    public void setUpdateImportantForAccessibilityOnSiblings(boolean updateImportantForAccessibilityOnSiblings) {
        this.updateImportantForAccessibilityOnSiblings = updateImportantForAccessibilityOnSiblings;
    }

    private void updateImportantForAccessibility(boolean expanded) {
        if (this.viewRef == null) {
            return;
        }
        ViewParent viewParent = ((View)this.viewRef.get()).getParent();
        if (!(viewParent instanceof CoordinatorLayout)) {
            return;
        }
        CoordinatorLayout parent = (CoordinatorLayout)viewParent;
        int childCount = parent.getChildCount();
        if (Build.VERSION.SDK_INT >= 16 && expanded) {
            if (this.importantForAccessibilityMap == null) {
                this.importantForAccessibilityMap = new HashMap<View, Integer>(childCount);
            } else {
                return;
            }
        }
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (child == this.viewRef.get()) continue;
            if (expanded) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.importantForAccessibilityMap.put(child, child.getImportantForAccessibility());
                }
                if (!this.updateImportantForAccessibilityOnSiblings) continue;
                ViewCompat.setImportantForAccessibility((View)child, (int)4);
                continue;
            }
            if (!this.updateImportantForAccessibilityOnSiblings || this.importantForAccessibilityMap == null || !this.importantForAccessibilityMap.containsKey(child)) continue;
            ViewCompat.setImportantForAccessibility((View)child, (int)this.importantForAccessibilityMap.get(child));
        }
        if (!expanded) {
            this.importantForAccessibilityMap = null;
        } else if (this.updateImportantForAccessibilityOnSiblings) {
            ((View)this.viewRef.get()).sendAccessibilityEvent(8);
        }
    }

    private void updateAccessibilityActions() {
        if (this.viewRef == null) {
            return;
        }
        View child = (View)this.viewRef.get();
        if (child == null) {
            return;
        }
        ViewCompat.removeAccessibilityAction((View)child, (int)524288);
        ViewCompat.removeAccessibilityAction((View)child, (int)262144);
        ViewCompat.removeAccessibilityAction((View)child, (int)0x100000);
        if (this.expandHalfwayActionId != -1) {
            ViewCompat.removeAccessibilityAction((View)child, (int)this.expandHalfwayActionId);
        }
        if (!this.fitToContents && this.state != 6) {
            this.expandHalfwayActionId = this.addAccessibilityActionForState(child, R.string.bottomsheet_action_expand_halfway, 6);
        }
        if (this.hideable && this.state != 5) {
            this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_DISMISS, 5);
        }
        switch (this.state) {
            case 3: {
                int nextState = this.fitToContents ? 4 : 6;
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_COLLAPSE, nextState);
                break;
            }
            case 6: {
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_COLLAPSE, 4);
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, 3);
                break;
            }
            case 4: {
                int nextState = this.fitToContents ? 3 : 6;
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, nextState);
                break;
            }
        }
    }

    private void replaceAccessibilityActionForState(V child, AccessibilityNodeInfoCompat.AccessibilityActionCompat action, int state) {
        ViewCompat.replaceAccessibilityAction(child, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)action, null, (AccessibilityViewCommand)this.createAccessibilityViewCommandForState(state));
    }

    private int addAccessibilityActionForState(V child, @StringRes int stringResId, int state) {
        return ViewCompat.addAccessibilityAction(child, (CharSequence)child.getResources().getString(stringResId), (AccessibilityViewCommand)this.createAccessibilityViewCommandForState(state));
    }

    private AccessibilityViewCommand createAccessibilityViewCommandForState(final int state) {
        return new AccessibilityViewCommand(){

            public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                BottomSheetBehavior.this.setState(state);
                return true;
            }
        };
    }

    protected static class SavedState
    extends AbsSavedState {
        final int state;
        int peekHeight;
        boolean fitToContents;
        boolean hideable;
        boolean skipCollapsed;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(@NonNull Parcel source) {
            this(source, null);
        }

        public SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            this.state = source.readInt();
            this.peekHeight = source.readInt();
            this.fitToContents = source.readInt() == 1;
            this.hideable = source.readInt() == 1;
            this.skipCollapsed = source.readInt() == 1;
        }

        public SavedState(Parcelable superState, @NonNull BottomSheetBehavior<?> behavior) {
            super(superState);
            this.state = behavior.state;
            this.peekHeight = ((BottomSheetBehavior)behavior).peekHeight;
            this.fitToContents = ((BottomSheetBehavior)behavior).fitToContents;
            this.hideable = behavior.hideable;
            this.skipCollapsed = ((BottomSheetBehavior)behavior).skipCollapsed;
        }

        @Deprecated
        public SavedState(Parcelable superstate, int state) {
            super(superstate);
            this.state = state;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
            out.writeInt(this.peekHeight);
            out.writeInt(this.fitToContents ? 1 : 0);
            out.writeInt(this.hideable ? 1 : 0);
            out.writeInt(this.skipCollapsed ? 1 : 0);
        }
    }

    private class SettleRunnable
    implements Runnable {
        private final View view;
        private boolean isPosted;
        int targetState;

        SettleRunnable(View view, int targetState) {
            this.view = view;
            this.targetState = targetState;
        }

        @Override
        public void run() {
            if (BottomSheetBehavior.this.viewDragHelper != null && BottomSheetBehavior.this.viewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.view, (Runnable)this);
            } else {
                BottomSheetBehavior.this.setStateInternal(this.targetState);
            }
            this.isPosted = false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface SaveFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface State {
    }

    public static abstract class BottomSheetCallback {
        public abstract void onStateChanged(@NonNull View var1, int var2);

        public abstract void onSlide(@NonNull View var1, float var2);
    }
}

