/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatDialog;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.shape.MaterialShapeDrawable;

public class BottomSheetDialog
extends AppCompatDialog {
    private BottomSheetBehavior<FrameLayout> behavior;
    private FrameLayout container;
    private CoordinatorLayout coordinator;
    private FrameLayout bottomSheet;
    boolean dismissWithAnimation;
    boolean cancelable = true;
    private boolean canceledOnTouchOutside = true;
    private boolean canceledOnTouchOutsideSet;
    private BottomSheetBehavior.BottomSheetCallback edgeToEdgeCallback;
    private boolean edgeToEdgeEnabled;
    @NonNull
    private BottomSheetBehavior.BottomSheetCallback bottomSheetCallback = new BottomSheetBehavior.BottomSheetCallback(){

        @Override
        public void onStateChanged(@NonNull View bottomSheet, int newState) {
            if (newState == 5) {
                BottomSheetDialog.this.cancel();
            }
        }

        @Override
        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
        }
    };

    public BottomSheetDialog(@NonNull Context context) {
        this(context, 0);
        this.edgeToEdgeEnabled = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.enableEdgeToEdge}).getBoolean(0, false);
    }

    public BottomSheetDialog(@NonNull Context context, @StyleRes int theme) {
        super(context, BottomSheetDialog.getThemeResId(context, theme));
        this.supportRequestWindowFeature(1);
        this.edgeToEdgeEnabled = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.enableEdgeToEdge}).getBoolean(0, false);
    }

    protected BottomSheetDialog(@NonNull Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.supportRequestWindowFeature(1);
        this.cancelable = cancelable;
        this.edgeToEdgeEnabled = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.enableEdgeToEdge}).getBoolean(0, false);
    }

    public void setContentView(@LayoutRes int layoutResId) {
        super.setContentView(this.wrapInBottomSheet(layoutResId, null, null));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        if (window != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                window.setStatusBarColor(0);
                window.addFlags(Integer.MIN_VALUE);
                if (Build.VERSION.SDK_INT < 23) {
                    window.addFlags(0x4000000);
                }
            }
            window.setLayout(-1, -1);
        }
    }

    public void setContentView(View view) {
        super.setContentView(this.wrapInBottomSheet(0, view, null));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(this.wrapInBottomSheet(0, view, params));
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        if (this.cancelable != cancelable) {
            this.cancelable = cancelable;
            if (this.behavior != null) {
                this.behavior.setHideable(cancelable);
            }
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.behavior != null && this.behavior.getState() == 5) {
            this.behavior.setState(4);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Window window = this.getWindow();
        if (window != null && Build.VERSION.SDK_INT >= 21) {
            boolean drawEdgeToEdge;
            boolean bl = drawEdgeToEdge = this.edgeToEdgeEnabled && Color.alpha((int)window.getNavigationBarColor()) < 255;
            if (this.container != null) {
                this.container.setFitsSystemWindows(!drawEdgeToEdge);
            }
            if (this.coordinator != null) {
                this.coordinator.setFitsSystemWindows(!drawEdgeToEdge);
            }
            if (drawEdgeToEdge) {
                int edgeToEdgeFlags = 768;
                window.getDecorView().setSystemUiVisibility(edgeToEdgeFlags);
            }
        }
    }

    public void cancel() {
        BottomSheetBehavior<FrameLayout> behavior = this.getBehavior();
        if (!this.dismissWithAnimation || behavior.getState() == 5) {
            super.cancel();
        } else {
            behavior.setState(5);
        }
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        if (cancel && !this.cancelable) {
            this.cancelable = true;
        }
        this.canceledOnTouchOutside = cancel;
        this.canceledOnTouchOutsideSet = true;
    }

    @NonNull
    public BottomSheetBehavior<FrameLayout> getBehavior() {
        if (this.behavior == null) {
            this.ensureContainerAndBehavior();
        }
        return this.behavior;
    }

    public void setDismissWithAnimation(boolean dismissWithAnimation) {
        this.dismissWithAnimation = dismissWithAnimation;
    }

    public boolean getDismissWithAnimation() {
        return this.dismissWithAnimation;
    }

    public boolean getEdgeToEdgeEnabled() {
        return this.edgeToEdgeEnabled;
    }

    private FrameLayout ensureContainerAndBehavior() {
        if (this.container == null) {
            this.container = (FrameLayout)View.inflate((Context)this.getContext(), (int)R.layout.design_bottom_sheet_dialog, null);
            this.coordinator = (CoordinatorLayout)this.container.findViewById(R.id.coordinator);
            this.bottomSheet = (FrameLayout)this.container.findViewById(R.id.design_bottom_sheet);
            this.behavior = BottomSheetBehavior.from(this.bottomSheet);
            this.behavior.addBottomSheetCallback(this.bottomSheetCallback);
            this.behavior.setHideable(this.cancelable);
        }
        return this.container;
    }

    private View wrapInBottomSheet(int layoutResId, @Nullable View view, @Nullable ViewGroup.LayoutParams params) {
        this.ensureContainerAndBehavior();
        CoordinatorLayout coordinator = (CoordinatorLayout)this.container.findViewById(R.id.coordinator);
        if (layoutResId != 0 && view == null) {
            view = this.getLayoutInflater().inflate(layoutResId, (ViewGroup)coordinator, false);
        }
        if (this.edgeToEdgeEnabled) {
            ViewCompat.setOnApplyWindowInsetsListener((View)this.bottomSheet, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

                public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat insets) {
                    if (BottomSheetDialog.this.edgeToEdgeCallback != null) {
                        BottomSheetDialog.this.behavior.removeBottomSheetCallback(BottomSheetDialog.this.edgeToEdgeCallback);
                    }
                    if (insets != null) {
                        BottomSheetDialog.this.edgeToEdgeCallback = new EdgeToEdgeCallback((View)BottomSheetDialog.this.bottomSheet, insets);
                        BottomSheetDialog.this.behavior.addBottomSheetCallback(BottomSheetDialog.this.edgeToEdgeCallback);
                    }
                    return insets;
                }
            });
        }
        this.bottomSheet.removeAllViews();
        if (params == null) {
            this.bottomSheet.addView(view);
        } else {
            this.bottomSheet.addView(view, params);
        }
        coordinator.findViewById(R.id.touch_outside).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BottomSheetDialog.this.cancelable && BottomSheetDialog.this.isShowing() && BottomSheetDialog.this.shouldWindowCloseOnTouchOutside()) {
                    BottomSheetDialog.this.cancel();
                }
            }
        });
        ViewCompat.setAccessibilityDelegate((View)this.bottomSheet, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                if (BottomSheetDialog.this.cancelable) {
                    info.addAction(0x100000);
                    info.setDismissable(true);
                } else {
                    info.setDismissable(false);
                }
            }

            public boolean performAccessibilityAction(View host, int action, Bundle args) {
                if (action == 0x100000 && BottomSheetDialog.this.cancelable) {
                    BottomSheetDialog.this.cancel();
                    return true;
                }
                return super.performAccessibilityAction(host, action, args);
            }
        });
        this.bottomSheet.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return true;
            }
        });
        return this.container;
    }

    boolean shouldWindowCloseOnTouchOutside() {
        if (!this.canceledOnTouchOutsideSet) {
            TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16843611});
            this.canceledOnTouchOutside = a.getBoolean(0, true);
            a.recycle();
            this.canceledOnTouchOutsideSet = true;
        }
        return this.canceledOnTouchOutside;
    }

    private static int getThemeResId(@NonNull Context context, int themeId) {
        if (themeId == 0) {
            TypedValue outValue = new TypedValue();
            themeId = context.getTheme().resolveAttribute(R.attr.bottomSheetDialogTheme, outValue, true) ? outValue.resourceId : R.style.Theme_Design_Light_BottomSheetDialog;
        }
        return themeId;
    }

    void removeDefaultCallback() {
        this.behavior.removeBottomSheetCallback(this.bottomSheetCallback);
    }

    public static void setLightStatusBar(@NonNull View view, boolean isLight) {
        if (Build.VERSION.SDK_INT >= 23) {
            int flags = view.getSystemUiVisibility();
            flags = isLight ? (flags |= 0x2000) : (flags &= 0xFFFFDFFF);
            view.setSystemUiVisibility(flags);
        }
    }

    private static class EdgeToEdgeCallback
    extends BottomSheetBehavior.BottomSheetCallback {
        private final boolean lightBottomSheet;
        private final boolean lightStatusBar;
        private final WindowInsetsCompat insetsCompat;

        private EdgeToEdgeCallback(@NonNull View bottomSheet, @NonNull WindowInsetsCompat insetsCompat) {
            this.insetsCompat = insetsCompat;
            this.lightStatusBar = Build.VERSION.SDK_INT >= 23 && (bottomSheet.getSystemUiVisibility() & 0x2000) != 0;
            MaterialShapeDrawable msd = BottomSheetBehavior.from(bottomSheet).getMaterialShapeDrawable();
            ColorStateList backgroundTint = msd != null ? msd.getFillColor() : ViewCompat.getBackgroundTintList((View)bottomSheet);
            this.lightBottomSheet = backgroundTint != null ? MaterialColors.isColorLight(backgroundTint.getDefaultColor()) : (bottomSheet.getBackground() instanceof ColorDrawable ? MaterialColors.isColorLight(((ColorDrawable)bottomSheet.getBackground()).getColor()) : this.lightStatusBar);
        }

        @Override
        public void onStateChanged(@NonNull View bottomSheet, int newState) {
            this.setPaddingForPosition(bottomSheet);
        }

        @Override
        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
            this.setPaddingForPosition(bottomSheet);
        }

        private void setPaddingForPosition(View bottomSheet) {
            if (bottomSheet.getTop() < this.insetsCompat.getSystemWindowInsetTop()) {
                BottomSheetDialog.setLightStatusBar(bottomSheet, this.lightBottomSheet);
                bottomSheet.setPadding(bottomSheet.getPaddingLeft(), this.insetsCompat.getSystemWindowInsetTop() - bottomSheet.getTop(), bottomSheet.getPaddingRight(), bottomSheet.getPaddingBottom());
            } else if (bottomSheet.getTop() != 0) {
                BottomSheetDialog.setLightStatusBar(bottomSheet, this.lightStatusBar);
                bottomSheet.setPadding(bottomSheet.getPaddingLeft(), 0, bottomSheet.getPaddingRight(), bottomSheet.getPaddingBottom());
            }
        }
    }
}

