/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.textfield.TextInputLayout;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

abstract class DateFormatTextWatcher
extends TextWatcherAdapter {
    private static final int VALIDATION_DELAY = 1000;
    @NonNull
    private final TextInputLayout textInputLayout;
    private final DateFormat dateFormat;
    private final CalendarConstraints constraints;
    private final String outOfRange;
    private final Runnable setErrorCallback;
    private Runnable setRangeErrorCallback;

    DateFormatTextWatcher(final String formatHint, DateFormat dateFormat, @NonNull TextInputLayout textInputLayout, CalendarConstraints constraints) {
        this.dateFormat = dateFormat;
        this.textInputLayout = textInputLayout;
        this.constraints = constraints;
        this.outOfRange = textInputLayout.getContext().getString(R.string.mtrl_picker_out_of_range);
        this.setErrorCallback = new Runnable(){

            @Override
            public void run() {
                TextInputLayout textLayout = DateFormatTextWatcher.this.textInputLayout;
                DateFormat df = DateFormatTextWatcher.this.dateFormat;
                Context context = textLayout.getContext();
                String invalidFormat = context.getString(R.string.mtrl_picker_invalid_format);
                String useLine = String.format(context.getString(R.string.mtrl_picker_invalid_format_use), formatHint);
                String exampleLine = String.format(context.getString(R.string.mtrl_picker_invalid_format_example), df.format(new Date(UtcDates.getTodayCalendar().getTimeInMillis())));
                textLayout.setError(invalidFormat + "\n" + useLine + "\n" + exampleLine);
                DateFormatTextWatcher.this.onInvalidDate();
            }
        };
    }

    abstract void onValidDate(@Nullable Long var1);

    void onInvalidDate() {
    }

    @Override
    public void onTextChanged(@NonNull CharSequence s, int start, int before, int count) {
        this.textInputLayout.removeCallbacks(this.setErrorCallback);
        this.textInputLayout.removeCallbacks(this.setRangeErrorCallback);
        this.textInputLayout.setError(null);
        this.onValidDate(null);
        if (TextUtils.isEmpty((CharSequence)s)) {
            return;
        }
        try {
            Date date = this.dateFormat.parse(s.toString());
            this.textInputLayout.setError(null);
            long milliseconds = date.getTime();
            if (this.constraints.getDateValidator().isValid(milliseconds) && this.constraints.isWithinBounds(milliseconds)) {
                this.onValidDate(date.getTime());
                return;
            }
            this.setRangeErrorCallback = this.createRangeErrorCallback(milliseconds);
            this.runValidation((View)this.textInputLayout, this.setRangeErrorCallback);
        }
        catch (ParseException e) {
            this.runValidation((View)this.textInputLayout, this.setErrorCallback);
        }
    }

    private Runnable createRangeErrorCallback(final long milliseconds) {
        return new Runnable(){

            @Override
            public void run() {
                DateFormatTextWatcher.this.textInputLayout.setError(String.format(DateFormatTextWatcher.this.outOfRange, DateStrings.getDateString(milliseconds)));
                DateFormatTextWatcher.this.onInvalidDate();
            }
        };
    }

    public void runValidation(View view, Runnable validation) {
        view.postDelayed(validation, 1000L);
    }
}

