/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.os.Build;
import android.text.format.DateUtils;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.google.android.material.datepicker.UtcDates;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class DateStrings {
    private DateStrings() {
    }

    static String getYearMonth(Context context, long timeInMillis) {
        int flags = 36;
        long offsetMillis = TimeZone.getDefault().getOffset(timeInMillis);
        return DateUtils.formatDateTime((Context)context, (long)(timeInMillis - offsetMillis), (int)flags);
    }

    static String getYearMonthDay(long timeInMillis) {
        return DateStrings.getYearMonthDay(timeInMillis, Locale.getDefault());
    }

    static String getYearMonthDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getYearAbbrMonthDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getMediumFormat(locale).format(new Date(timeInMillis));
    }

    static String getMonthDay(long timeInMillis) {
        return DateStrings.getMonthDay(timeInMillis, Locale.getDefault());
    }

    static String getMonthDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getAbbrMonthDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getMediumNoYear(locale).format(new Date(timeInMillis));
    }

    static String getMonthDayOfWeekDay(long timeInMillis) {
        return DateStrings.getMonthDayOfWeekDay(timeInMillis, Locale.getDefault());
    }

    static String getMonthDayOfWeekDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getAbbrMonthWeekdayDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getFullFormat(locale).format(new Date(timeInMillis));
    }

    static String getYearMonthDayOfWeekDay(long timeInMillis) {
        return DateStrings.getYearMonthDayOfWeekDay(timeInMillis, Locale.getDefault());
    }

    static String getYearMonthDayOfWeekDay(long timeInMillis, Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            return UtcDates.getYearAbbrMonthWeekdayDayFormat(locale).format(new Date(timeInMillis));
        }
        return UtcDates.getFullFormat(locale).format(new Date(timeInMillis));
    }

    static String getDateString(long timeInMillis) {
        return DateStrings.getDateString(timeInMillis, null);
    }

    static String getDateString(long timeInMillis, @Nullable SimpleDateFormat userDefinedDateFormat) {
        Calendar currentCalendar = UtcDates.getTodayCalendar();
        Calendar calendarDate = UtcDates.getUtcCalendar();
        calendarDate.setTimeInMillis(timeInMillis);
        if (userDefinedDateFormat != null) {
            Date date = new Date(timeInMillis);
            return userDefinedDateFormat.format(date);
        }
        if (currentCalendar.get(1) == calendarDate.get(1)) {
            return DateStrings.getMonthDay(timeInMillis);
        }
        return DateStrings.getYearMonthDay(timeInMillis);
    }

    static Pair<String, String> getDateRangeString(@Nullable Long start, @Nullable Long end) {
        return DateStrings.getDateRangeString(start, end, null);
    }

    static Pair<String, String> getDateRangeString(@Nullable Long start, @Nullable Long end, @Nullable SimpleDateFormat userDefinedDateFormat) {
        if (start == null && end == null) {
            return Pair.create(null, null);
        }
        if (start == null) {
            return Pair.create(null, (Object)DateStrings.getDateString(end, userDefinedDateFormat));
        }
        if (end == null) {
            return Pair.create((Object)DateStrings.getDateString(start, userDefinedDateFormat), null);
        }
        Calendar currentCalendar = UtcDates.getTodayCalendar();
        Calendar startCalendar = UtcDates.getUtcCalendar();
        startCalendar.setTimeInMillis(start);
        Calendar endCalendar = UtcDates.getUtcCalendar();
        endCalendar.setTimeInMillis(end);
        if (userDefinedDateFormat != null) {
            Date startDate = new Date(start);
            Date endDate = new Date(end);
            return Pair.create((Object)userDefinedDateFormat.format(startDate), (Object)userDefinedDateFormat.format(endDate));
        }
        if (startCalendar.get(1) == endCalendar.get(1)) {
            if (startCalendar.get(1) == currentCalendar.get(1)) {
                return Pair.create((Object)DateStrings.getMonthDay(start, Locale.getDefault()), (Object)DateStrings.getMonthDay(end, Locale.getDefault()));
            }
            return Pair.create((Object)DateStrings.getMonthDay(start, Locale.getDefault()), (Object)DateStrings.getYearMonthDay(end, Locale.getDefault()));
        }
        return Pair.create((Object)DateStrings.getYearMonthDay(start, Locale.getDefault()), (Object)DateStrings.getYearMonthDay(end, Locale.getDefault()));
    }
}

