/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.imageview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import com.google.android.material.R;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class ShapeableImageView
extends AppCompatImageView
implements Shapeable {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ShapeableImageView;
    private static final int UNDEFINED_PADDING = Integer.MIN_VALUE;
    private final ShapeAppearancePathProvider pathProvider = ShapeAppearancePathProvider.getInstance();
    private final RectF destination;
    private final RectF maskRect;
    private final Paint borderPaint;
    private final Paint clearPaint;
    private final Path path = new Path();
    @Nullable
    private ColorStateList strokeColor;
    @Nullable
    private MaterialShapeDrawable shadowDrawable;
    private ShapeAppearanceModel shapeAppearanceModel;
    @Dimension
    private float strokeWidth;
    private Path maskPath;
    @Dimension
    private int leftContentPadding;
    @Dimension
    private int topContentPadding;
    @Dimension
    private int rightContentPadding;
    @Dimension
    private int bottomContentPadding;
    @Dimension
    private int startContentPadding;
    @Dimension
    private int endContentPadding;
    private boolean hasAdjustedPaddingAfterLayoutDirectionResolved = false;

    public ShapeableImageView(Context context) {
        this(context, null, 0);
    }

    public ShapeableImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeableImageView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyle, DEF_STYLE_RES), attrs, defStyle);
        int contentPadding;
        context = this.getContext();
        this.clearPaint = new Paint();
        this.clearPaint.setAntiAlias(true);
        this.clearPaint.setColor(-1);
        this.clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.destination = new RectF();
        this.maskRect = new RectF();
        this.maskPath = new Path();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ShapeableImageView, defStyle, DEF_STYLE_RES);
        this.strokeColor = MaterialResources.getColorStateList(context, attributes, R.styleable.ShapeableImageView_strokeColor);
        this.strokeWidth = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_strokeWidth, 0);
        this.leftContentPadding = contentPadding = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPadding, 0);
        this.topContentPadding = contentPadding;
        this.rightContentPadding = contentPadding;
        this.bottomContentPadding = contentPadding;
        this.leftContentPadding = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingLeft, contentPadding);
        this.topContentPadding = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingTop, contentPadding);
        this.rightContentPadding = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingRight, contentPadding);
        this.bottomContentPadding = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingBottom, contentPadding);
        this.startContentPadding = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingStart, Integer.MIN_VALUE);
        this.endContentPadding = attributes.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingEnd, Integer.MIN_VALUE);
        attributes.recycle();
        this.borderPaint = new Paint();
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setAntiAlias(true);
        this.shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyle, DEF_STYLE_RES).build();
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new OutlineProvider());
        }
    }

    protected void onDetachedFromWindow() {
        this.setLayerType(0, null);
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setLayerType(2, null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.hasAdjustedPaddingAfterLayoutDirectionResolved) {
            return;
        }
        if (Build.VERSION.SDK_INT > 19 && !this.isLayoutDirectionResolved()) {
            return;
        }
        this.hasAdjustedPaddingAfterLayoutDirectionResolved = true;
        if (Build.VERSION.SDK_INT >= 21 && (this.isPaddingRelative() || this.isContentPaddingRelative())) {
            this.setPaddingRelative(super.getPaddingStart(), super.getPaddingTop(), super.getPaddingEnd(), super.getPaddingBottom());
            return;
        }
        this.setPadding(super.getPaddingLeft(), super.getPaddingTop(), super.getPaddingRight(), super.getPaddingBottom());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(this.maskPath, this.clearPaint);
        this.drawStroke(canvas);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.updateShapeMask(width, height);
    }

    public void setContentPadding(@Dimension int left, @Dimension int top, @Dimension int right, @Dimension int bottom) {
        this.startContentPadding = Integer.MIN_VALUE;
        this.endContentPadding = Integer.MIN_VALUE;
        super.setPadding(super.getPaddingLeft() - this.leftContentPadding + left, super.getPaddingTop() - this.topContentPadding + top, super.getPaddingRight() - this.rightContentPadding + right, super.getPaddingBottom() - this.bottomContentPadding + bottom);
        this.leftContentPadding = left;
        this.topContentPadding = top;
        this.rightContentPadding = right;
        this.bottomContentPadding = bottom;
    }

    @RequiresApi(value=17)
    public void setContentPaddingRelative(@Dimension int start, @Dimension int top, @Dimension int end, @Dimension int bottom) {
        super.setPaddingRelative(super.getPaddingStart() - this.getContentPaddingStart() + start, super.getPaddingTop() - this.topContentPadding + top, super.getPaddingEnd() - this.getContentPaddingEnd() + end, super.getPaddingBottom() - this.bottomContentPadding + bottom);
        this.leftContentPadding = this.isRtl() ? end : start;
        this.topContentPadding = top;
        this.rightContentPadding = this.isRtl() ? start : end;
        this.bottomContentPadding = bottom;
    }

    private boolean isContentPaddingRelative() {
        return this.startContentPadding != Integer.MIN_VALUE || this.endContentPadding != Integer.MIN_VALUE;
    }

    @Dimension
    public int getContentPaddingBottom() {
        return this.bottomContentPadding;
    }

    @Dimension
    public final int getContentPaddingEnd() {
        if (this.endContentPadding != Integer.MIN_VALUE) {
            return this.endContentPadding;
        }
        return this.isRtl() ? this.leftContentPadding : this.rightContentPadding;
    }

    @Dimension
    public int getContentPaddingLeft() {
        if (this.isContentPaddingRelative()) {
            if (this.isRtl() && this.endContentPadding != Integer.MIN_VALUE) {
                return this.endContentPadding;
            }
            if (!this.isRtl() && this.startContentPadding != Integer.MIN_VALUE) {
                return this.startContentPadding;
            }
        }
        return this.leftContentPadding;
    }

    @Dimension
    public int getContentPaddingRight() {
        if (this.isContentPaddingRelative()) {
            if (this.isRtl() && this.startContentPadding != Integer.MIN_VALUE) {
                return this.startContentPadding;
            }
            if (!this.isRtl() && this.endContentPadding != Integer.MIN_VALUE) {
                return this.endContentPadding;
            }
        }
        return this.rightContentPadding;
    }

    @Dimension
    public final int getContentPaddingStart() {
        if (this.startContentPadding != Integer.MIN_VALUE) {
            return this.startContentPadding;
        }
        return this.isRtl() ? this.rightContentPadding : this.leftContentPadding;
    }

    @Dimension
    public int getContentPaddingTop() {
        return this.topContentPadding;
    }

    private boolean isRtl() {
        return Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1;
    }

    public void setPadding(@Dimension int left, @Dimension int top, @Dimension int right, @Dimension int bottom) {
        super.setPadding(left + this.getContentPaddingLeft(), top + this.getContentPaddingTop(), right + this.getContentPaddingRight(), bottom + this.getContentPaddingBottom());
    }

    public void setPaddingRelative(@Dimension int start, @Dimension int top, @Dimension int end, @Dimension int bottom) {
        super.setPaddingRelative(start + this.getContentPaddingStart(), top + this.getContentPaddingTop(), end + this.getContentPaddingEnd(), bottom + this.getContentPaddingBottom());
    }

    @Dimension
    public int getPaddingBottom() {
        return super.getPaddingBottom() - this.getContentPaddingBottom();
    }

    @Dimension
    public int getPaddingEnd() {
        return super.getPaddingEnd() - this.getContentPaddingEnd();
    }

    @Dimension
    public int getPaddingLeft() {
        return super.getPaddingLeft() - this.getContentPaddingLeft();
    }

    @Dimension
    public int getPaddingRight() {
        return super.getPaddingRight() - this.getContentPaddingRight();
    }

    @Dimension
    public int getPaddingStart() {
        return super.getPaddingStart() - this.getContentPaddingStart();
    }

    @Dimension
    public int getPaddingTop() {
        return super.getPaddingTop() - this.getContentPaddingTop();
    }

    @Override
    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        if (this.shadowDrawable != null) {
            this.shadowDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        }
        this.updateShapeMask(this.getWidth(), this.getHeight());
        this.invalidate();
        if (Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    @Override
    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    private void updateShapeMask(int width, int height) {
        this.destination.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(width - this.getPaddingRight()), (float)(height - this.getPaddingBottom()));
        this.pathProvider.calculatePath(this.shapeAppearanceModel, 1.0f, this.destination, this.path);
        this.maskPath.rewind();
        this.maskPath.addPath(this.path);
        this.maskRect.set(0.0f, 0.0f, (float)width, (float)height);
        this.maskPath.addRect(this.maskRect, Path.Direction.CCW);
    }

    private void drawStroke(Canvas canvas) {
        if (this.strokeColor == null) {
            return;
        }
        this.borderPaint.setStrokeWidth(this.strokeWidth);
        int colorForState = this.strokeColor.getColorForState(this.getDrawableState(), this.strokeColor.getDefaultColor());
        if (this.strokeWidth > 0.0f && colorForState != 0) {
            this.borderPaint.setColor(colorForState);
            canvas.drawPath(this.path, this.borderPaint);
        }
    }

    public void setStrokeColorResource(@ColorRes int strokeColorResourceId) {
        this.setStrokeColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)strokeColorResourceId));
    }

    @Nullable
    public ColorStateList getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeWidth(@Dimension float strokeWidth) {
        if (this.strokeWidth != strokeWidth) {
            this.strokeWidth = strokeWidth;
            this.invalidate();
        }
    }

    public void setStrokeWidthResource(@DimenRes int strokeWidthResourceId) {
        this.setStrokeWidth(this.getResources().getDimensionPixelSize(strokeWidthResourceId));
    }

    @Dimension
    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeColor(@Nullable ColorStateList strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    @TargetApi(value=21)
    class OutlineProvider
    extends ViewOutlineProvider {
        private final Rect rect = new Rect();

        OutlineProvider() {
        }

        public void getOutline(View view, Outline outline) {
            if (ShapeableImageView.this.shapeAppearanceModel == null) {
                return;
            }
            if (ShapeableImageView.this.shadowDrawable == null) {
                ShapeableImageView.this.shadowDrawable = new MaterialShapeDrawable(ShapeableImageView.this.shapeAppearanceModel);
            }
            ShapeableImageView.this.destination.round(this.rect);
            ShapeableImageView.this.shadowDrawable.setBounds(this.rect);
            ShapeableImageView.this.shadowDrawable.getOutline(outline);
        }
    }
}

