/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import com.google.android.material.internal.ViewGroupOverlayApi14;
import com.google.android.material.internal.ViewOverlayImpl;
import com.google.android.material.internal.ViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class ViewOverlayApi14
implements ViewOverlayImpl {
    protected OverlayViewGroup overlayViewGroup;

    ViewOverlayApi14(Context context, ViewGroup hostView, View requestingView) {
        this.overlayViewGroup = new OverlayViewGroup(context, hostView, requestingView, this);
    }

    static ViewOverlayApi14 createFrom(View view) {
        ViewGroup contentView = ViewUtils.getContentView(view);
        if (contentView != null) {
            int numChildren = contentView.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                View child = contentView.getChildAt(i);
                if (!(child instanceof OverlayViewGroup)) continue;
                return ((OverlayViewGroup)child).viewOverlay;
            }
            return new ViewGroupOverlayApi14(contentView.getContext(), contentView, view);
        }
        return null;
    }

    @Override
    public void add(@NonNull Drawable drawable2) {
        this.overlayViewGroup.add(drawable2);
    }

    @Override
    public void remove(@NonNull Drawable drawable2) {
        this.overlayViewGroup.remove(drawable2);
    }

    @SuppressLint(value={"ViewConstructor", "PrivateApi"})
    static class OverlayViewGroup
    extends ViewGroup {
        static Method invalidateChildInParentFastMethod;
        ViewGroup hostView;
        View requestingView;
        ArrayList<Drawable> drawables = null;
        ViewOverlayApi14 viewOverlay;
        private boolean disposed;

        OverlayViewGroup(Context context, ViewGroup hostView, View requestingView, ViewOverlayApi14 viewOverlay) {
            super(context);
            this.hostView = hostView;
            this.requestingView = requestingView;
            this.setRight(hostView.getWidth());
            this.setBottom(hostView.getHeight());
            hostView.addView((View)this);
            this.viewOverlay = viewOverlay;
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            return false;
        }

        public void add(Drawable drawable2) {
            this.assertNotDisposed();
            if (this.drawables == null) {
                this.drawables = new ArrayList();
            }
            if (!this.drawables.contains(drawable2)) {
                this.drawables.add(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback((Drawable.Callback)this);
            }
        }

        public void remove(Drawable drawable2) {
            if (this.drawables != null) {
                this.drawables.remove(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback(null);
                this.disposeIfEmpty();
            }
        }

        protected boolean verifyDrawable(@NonNull Drawable who) {
            return super.verifyDrawable(who) || this.drawables != null && this.drawables.contains(who);
        }

        public void add(View child) {
            this.assertNotDisposed();
            if (child.getParent() instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)child.getParent();
                if (parent != this.hostView && parent.getParent() != null && ViewCompat.isAttachedToWindow((View)parent)) {
                    int[] parentLocation = new int[2];
                    int[] hostViewLocation = new int[2];
                    parent.getLocationOnScreen(parentLocation);
                    this.hostView.getLocationOnScreen(hostViewLocation);
                    ViewCompat.offsetLeftAndRight((View)child, (int)(parentLocation[0] - hostViewLocation[0]));
                    ViewCompat.offsetTopAndBottom((View)child, (int)(parentLocation[1] - hostViewLocation[1]));
                }
                parent.removeView(child);
                if (child.getParent() != null) {
                    parent.removeView(child);
                }
            }
            super.addView(child);
        }

        public void remove(View view) {
            super.removeView(view);
            this.disposeIfEmpty();
        }

        private void assertNotDisposed() {
            if (this.disposed) {
                throw new IllegalStateException("This overlay was disposed already. Please use a new one via ViewGroupUtils.getOverlay()");
            }
        }

        private void disposeIfEmpty() {
            if (this.getChildCount() == 0 && (this.drawables == null || this.drawables.size() == 0)) {
                this.disposed = true;
                this.hostView.removeView((View)this);
            }
        }

        public void invalidateDrawable(@NonNull Drawable drawable2) {
            this.invalidate(drawable2.getBounds());
        }

        protected void dispatchDraw(Canvas canvas) {
            int[] contentViewLocation = new int[2];
            int[] hostViewLocation = new int[2];
            this.hostView.getLocationOnScreen(contentViewLocation);
            this.requestingView.getLocationOnScreen(hostViewLocation);
            canvas.translate((float)(hostViewLocation[0] - contentViewLocation[0]), (float)(hostViewLocation[1] - contentViewLocation[1]));
            canvas.clipRect(new Rect(0, 0, this.requestingView.getWidth(), this.requestingView.getHeight()));
            super.dispatchDraw(canvas);
            int numDrawables = this.drawables == null ? 0 : this.drawables.size();
            for (int i = 0; i < numDrawables; ++i) {
                this.drawables.get(i).draw(canvas);
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        private void getOffset(int[] offset) {
            int[] contentViewLocation = new int[2];
            int[] hostViewLocation = new int[2];
            this.hostView.getLocationOnScreen(contentViewLocation);
            this.requestingView.getLocationOnScreen(hostViewLocation);
            offset[0] = hostViewLocation[0] - contentViewLocation[0];
            offset[1] = hostViewLocation[1] - contentViewLocation[1];
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        protected ViewParent invalidateChildInParentFast(int left, int top, Rect dirty) {
            if (this.hostView != null && invalidateChildInParentFastMethod != null) {
                try {
                    int[] offset = new int[2];
                    this.getOffset(offset);
                    invalidateChildInParentFastMethod.invoke((Object)this.hostView, left, top, dirty);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
            if (this.hostView != null) {
                dirty.offset(location[0], location[1]);
                if (this.hostView != null) {
                    location[0] = 0;
                    location[1] = 0;
                    int[] offset = new int[2];
                    this.getOffset(offset);
                    dirty.offset(offset[0], offset[1]);
                    return super.invalidateChildInParent(location, dirty);
                }
                this.invalidate(dirty);
            }
            return null;
        }

        static {
            try {
                invalidateChildInParentFastMethod = ViewGroup.class.getDeclaredMethod("invalidateChildInParentFast", Integer.TYPE, Integer.TYPE, Rect.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

