/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigationrail;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.TintTypedArray;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.navigationrail.NavigationRailMenuView;

public class NavigationRailView
extends NavigationBarView {
    static final int DEFAULT_MENU_GRAVITY = 49;
    static final int MAX_ITEM_COUNT = 7;
    private static final int DEFAULT_HEADER_GRAVITY = 49;
    private final int topMargin;
    @Nullable
    private View headerView;

    public NavigationRailView(@NonNull Context context) {
        this(context, null);
    }

    public NavigationRailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.navigationRailStyle);
    }

    public NavigationRailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Widget_MaterialComponents_NavigationRailView);
    }

    public NavigationRailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = this.getResources();
        this.topMargin = res.getDimensionPixelSize(R.dimen.mtrl_navigation_rail_margin);
        context = this.getContext();
        TintTypedArray attributes = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.NavigationRailView, defStyleAttr, defStyleRes, new int[0]);
        int headerLayoutRes = attributes.getResourceId(R.styleable.NavigationRailView_headerLayout, 0);
        if (headerLayoutRes != 0) {
            this.addHeaderView(headerLayoutRes);
        }
        this.setMenuGravity(attributes.getInt(R.styleable.NavigationRailView_menuGravity, 49));
        attributes.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minWidthSpec = this.makeMinWidthSpec(widthMeasureSpec);
        super.onMeasure(minWidthSpec, heightMeasureSpec);
        if (this.isHeaderViewVisible()) {
            int maxMenuHeight = this.getMeasuredHeight() - this.headerView.getMeasuredHeight() - this.topMargin;
            int menuHeightSpec = View.MeasureSpec.makeMeasureSpec((int)maxMenuHeight, (int)Integer.MIN_VALUE);
            this.measureChild((View)this.getNavigationRailMenuView(), minWidthSpec, menuHeightSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        NavigationRailMenuView menuView = this.getNavigationRailMenuView();
        int offsetY = 0;
        if (this.isHeaderViewVisible()) {
            int usedTop = this.headerView.getBottom() + this.topMargin;
            int menuTop = menuView.getTop();
            if (menuTop < usedTop) {
                offsetY = usedTop - menuTop;
            }
        } else if (menuView.isTopGravity()) {
            offsetY = this.topMargin;
        }
        if (offsetY > 0) {
            menuView.layout(menuView.getLeft(), menuView.getTop() + offsetY, menuView.getRight(), menuView.getBottom() + offsetY);
        }
    }

    public void addHeaderView(@LayoutRes int layoutRes) {
        this.addHeaderView(LayoutInflater.from((Context)this.getContext()).inflate(layoutRes, (ViewGroup)this, false));
    }

    public void addHeaderView(@NonNull View headerView) {
        this.removeHeaderView();
        this.headerView = headerView;
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 49;
        params.topMargin = this.topMargin;
        this.addView(headerView, 0, (ViewGroup.LayoutParams)params);
    }

    @Nullable
    public View getHeaderView() {
        return this.headerView;
    }

    public void removeHeaderView() {
        if (this.headerView != null) {
            this.removeView(this.headerView);
            this.headerView = null;
        }
    }

    public void setMenuGravity(int gravity) {
        this.getNavigationRailMenuView().setMenuGravity(gravity);
    }

    public int getMenuGravity() {
        return this.getNavigationRailMenuView().getMenuGravity();
    }

    @Override
    public int getMaxItemCount() {
        return 7;
    }

    private NavigationRailMenuView getNavigationRailMenuView() {
        return (NavigationRailMenuView)this.getMenuView();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected NavigationRailMenuView createNavigationBarMenuView(@NonNull Context context) {
        return new NavigationRailMenuView(context);
    }

    private int makeMinWidthSpec(int measureSpec) {
        int minWidth = this.getSuggestedMinimumWidth();
        if (View.MeasureSpec.getMode((int)measureSpec) != 0x40000000 && minWidth > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)measureSpec), minWidth += this.getPaddingLeft() + this.getPaddingRight()), (int)0x40000000);
        }
        return measureSpec;
    }

    private boolean isHeaderViewVisible() {
        return this.headerView != null && this.headerView.getVisibility() != 8;
    }
}

