/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.EdgeTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapePath;

public class ShapeAppearancePathProvider {
    private final ShapePath[] cornerPaths = new ShapePath[4];
    private final Matrix[] cornerTransforms = new Matrix[4];
    private final Matrix[] edgeTransforms = new Matrix[4];
    private final PointF pointF = new PointF();
    private final Path overlappedEdgePath = new Path();
    private final Path boundsPath = new Path();
    private final ShapePath shapePath = new ShapePath();
    private final float[] scratch = new float[2];
    private final float[] scratch2 = new float[2];
    private final Path edgePath = new Path();
    private final Path cornerPath = new Path();
    private boolean edgeIntersectionCheckEnabled = true;

    public ShapeAppearancePathProvider() {
        for (int i = 0; i < 4; ++i) {
            this.cornerPaths[i] = new ShapePath();
            this.cornerTransforms[i] = new Matrix();
            this.edgeTransforms[i] = new Matrix();
        }
    }

    @UiThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static ShapeAppearancePathProvider getInstance() {
        return Lazy.INSTANCE;
    }

    public void calculatePath(ShapeAppearanceModel shapeAppearanceModel, float interpolation, RectF bounds, @NonNull Path path) {
        this.calculatePath(shapeAppearanceModel, interpolation, bounds, null, path);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void calculatePath(ShapeAppearanceModel shapeAppearanceModel, float interpolation, RectF bounds, PathListener pathListener, @NonNull Path path) {
        int index;
        path.rewind();
        this.overlappedEdgePath.rewind();
        this.boundsPath.rewind();
        this.boundsPath.addRect(bounds, Path.Direction.CW);
        ShapeAppearancePathSpec spec = new ShapeAppearancePathSpec(shapeAppearanceModel, interpolation, bounds, pathListener, path);
        for (index = 0; index < 4; ++index) {
            this.setCornerPathAndTransform(spec, index);
            this.setEdgePathAndTransform(index);
        }
        for (index = 0; index < 4; ++index) {
            this.appendCornerPath(spec, index);
            this.appendEdgePath(spec, index);
        }
        path.close();
        this.overlappedEdgePath.close();
        if (Build.VERSION.SDK_INT >= 19 && !this.overlappedEdgePath.isEmpty()) {
            path.op(this.overlappedEdgePath, Path.Op.UNION);
        }
    }

    private void setCornerPathAndTransform(@NonNull ShapeAppearancePathSpec spec, int index) {
        CornerSize size = this.getCornerSizeForIndex(index, spec.shapeAppearanceModel);
        this.getCornerTreatmentForIndex(index, spec.shapeAppearanceModel).getCornerPath(this.cornerPaths[index], 90.0f, spec.interpolation, spec.bounds, size);
        float edgeAngle = this.angleOfEdge(index);
        this.cornerTransforms[index].reset();
        this.getCoordinatesOfCorner(index, spec.bounds, this.pointF);
        this.cornerTransforms[index].setTranslate(this.pointF.x, this.pointF.y);
        this.cornerTransforms[index].preRotate(edgeAngle);
    }

    private void setEdgePathAndTransform(int index) {
        this.scratch[0] = this.cornerPaths[index].getEndX();
        this.scratch[1] = this.cornerPaths[index].getEndY();
        this.cornerTransforms[index].mapPoints(this.scratch);
        float edgeAngle = this.angleOfEdge(index);
        this.edgeTransforms[index].reset();
        this.edgeTransforms[index].setTranslate(this.scratch[0], this.scratch[1]);
        this.edgeTransforms[index].preRotate(edgeAngle);
    }

    private void appendCornerPath(@NonNull ShapeAppearancePathSpec spec, int index) {
        this.scratch[0] = this.cornerPaths[index].getStartX();
        this.scratch[1] = this.cornerPaths[index].getStartY();
        this.cornerTransforms[index].mapPoints(this.scratch);
        if (index == 0) {
            spec.path.moveTo(this.scratch[0], this.scratch[1]);
        } else {
            spec.path.lineTo(this.scratch[0], this.scratch[1]);
        }
        this.cornerPaths[index].applyToPath(this.cornerTransforms[index], spec.path);
        if (spec.pathListener != null) {
            spec.pathListener.onCornerPathCreated(this.cornerPaths[index], this.cornerTransforms[index], index);
        }
    }

    private void appendEdgePath(@NonNull ShapeAppearancePathSpec spec, int index) {
        int nextIndex = (index + 1) % 4;
        this.scratch[0] = this.cornerPaths[index].getEndX();
        this.scratch[1] = this.cornerPaths[index].getEndY();
        this.cornerTransforms[index].mapPoints(this.scratch);
        this.scratch2[0] = this.cornerPaths[nextIndex].getStartX();
        this.scratch2[1] = this.cornerPaths[nextIndex].getStartY();
        this.cornerTransforms[nextIndex].mapPoints(this.scratch2);
        float edgeLength = (float)Math.hypot(this.scratch[0] - this.scratch2[0], this.scratch[1] - this.scratch2[1]);
        edgeLength = Math.max(edgeLength - 0.001f, 0.0f);
        float center = this.getEdgeCenterForIndex(spec.bounds, index);
        this.shapePath.reset(0.0f, 0.0f);
        EdgeTreatment edgeTreatment = this.getEdgeTreatmentForIndex(index, spec.shapeAppearanceModel);
        edgeTreatment.getEdgePath(edgeLength, center, spec.interpolation, this.shapePath);
        this.edgePath.reset();
        this.shapePath.applyToPath(this.edgeTransforms[index], this.edgePath);
        if (this.edgeIntersectionCheckEnabled && Build.VERSION.SDK_INT >= 19 && (edgeTreatment.forceIntersection() || this.pathOverlapsCorner(this.edgePath, index) || this.pathOverlapsCorner(this.edgePath, nextIndex))) {
            this.edgePath.op(this.edgePath, this.boundsPath, Path.Op.DIFFERENCE);
            this.scratch[0] = this.shapePath.getStartX();
            this.scratch[1] = this.shapePath.getStartY();
            this.edgeTransforms[index].mapPoints(this.scratch);
            this.overlappedEdgePath.moveTo(this.scratch[0], this.scratch[1]);
            this.shapePath.applyToPath(this.edgeTransforms[index], this.overlappedEdgePath);
        } else {
            this.shapePath.applyToPath(this.edgeTransforms[index], spec.path);
        }
        if (spec.pathListener != null) {
            spec.pathListener.onEdgePathCreated(this.shapePath, this.edgeTransforms[index], index);
        }
    }

    @RequiresApi(value=19)
    private boolean pathOverlapsCorner(Path edgePath, int index) {
        this.cornerPath.reset();
        this.cornerPaths[index].applyToPath(this.cornerTransforms[index], this.cornerPath);
        RectF bounds = new RectF();
        edgePath.computeBounds(bounds, true);
        this.cornerPath.computeBounds(bounds, true);
        edgePath.op(this.cornerPath, Path.Op.INTERSECT);
        edgePath.computeBounds(bounds, true);
        return !bounds.isEmpty() || bounds.width() > 1.0f && bounds.height() > 1.0f;
    }

    private float getEdgeCenterForIndex(@NonNull RectF bounds, int index) {
        this.scratch[0] = this.cornerPaths[index].endX;
        this.scratch[1] = this.cornerPaths[index].endY;
        this.cornerTransforms[index].mapPoints(this.scratch);
        switch (index) {
            case 1: 
            case 3: {
                return Math.abs(bounds.centerX() - this.scratch[0]);
            }
        }
        return Math.abs(bounds.centerY() - this.scratch[1]);
    }

    private CornerTreatment getCornerTreatmentForIndex(int index, @NonNull ShapeAppearanceModel shapeAppearanceModel) {
        switch (index) {
            case 1: {
                return shapeAppearanceModel.getBottomRightCorner();
            }
            case 2: {
                return shapeAppearanceModel.getBottomLeftCorner();
            }
            case 3: {
                return shapeAppearanceModel.getTopLeftCorner();
            }
        }
        return shapeAppearanceModel.getTopRightCorner();
    }

    private CornerSize getCornerSizeForIndex(int index, @NonNull ShapeAppearanceModel shapeAppearanceModel) {
        switch (index) {
            case 1: {
                return shapeAppearanceModel.getBottomRightCornerSize();
            }
            case 2: {
                return shapeAppearanceModel.getBottomLeftCornerSize();
            }
            case 3: {
                return shapeAppearanceModel.getTopLeftCornerSize();
            }
        }
        return shapeAppearanceModel.getTopRightCornerSize();
    }

    private EdgeTreatment getEdgeTreatmentForIndex(int index, @NonNull ShapeAppearanceModel shapeAppearanceModel) {
        switch (index) {
            case 1: {
                return shapeAppearanceModel.getBottomEdge();
            }
            case 2: {
                return shapeAppearanceModel.getLeftEdge();
            }
            case 3: {
                return shapeAppearanceModel.getTopEdge();
            }
        }
        return shapeAppearanceModel.getRightEdge();
    }

    private void getCoordinatesOfCorner(int index, @NonNull RectF bounds, @NonNull PointF pointF) {
        switch (index) {
            case 1: {
                pointF.set(bounds.right, bounds.bottom);
                break;
            }
            case 2: {
                pointF.set(bounds.left, bounds.bottom);
                break;
            }
            case 3: {
                pointF.set(bounds.left, bounds.top);
                break;
            }
            default: {
                pointF.set(bounds.right, bounds.top);
            }
        }
    }

    private float angleOfEdge(int index) {
        return 90 * (index + 1);
    }

    void setEdgeIntersectionCheckEnable(boolean enable) {
        this.edgeIntersectionCheckEnabled = enable;
    }

    static final class ShapeAppearancePathSpec {
        @NonNull
        public final ShapeAppearanceModel shapeAppearanceModel;
        @NonNull
        public final Path path;
        @NonNull
        public final RectF bounds;
        @Nullable
        public final PathListener pathListener;
        public final float interpolation;

        ShapeAppearancePathSpec(@NonNull ShapeAppearanceModel shapeAppearanceModel, float interpolation, RectF bounds, @Nullable PathListener pathListener, Path path) {
            this.pathListener = pathListener;
            this.shapeAppearanceModel = shapeAppearanceModel;
            this.interpolation = interpolation;
            this.bounds = bounds;
            this.path = path;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface PathListener {
        public void onCornerPathCreated(ShapePath var1, Matrix var2, int var3);

        public void onEdgePathCreated(ShapePath var1, Matrix var2, int var3);
    }

    private static class Lazy {
        static final ShapeAppearancePathProvider INSTANCE = new ShapeAppearancePathProvider();

        private Lazy() {
        }
    }
}

