/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.slider;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.slider.BaseOnChangeListener;
import com.google.android.material.slider.BaseOnSliderTouchListener;
import com.google.android.material.slider.BaseSlider;
import java.util.ArrayList;
import java.util.List;

public class RangeSlider
extends BaseSlider<RangeSlider, OnChangeListener, OnSliderTouchListener> {
    private float minSeparation;
    private int separationUnit;

    public RangeSlider(@NonNull Context context) {
        this(context, null);
    }

    public RangeSlider(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sliderStyle);
    }

    public RangeSlider(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.RangeSlider, defStyleAttr, DEF_STYLE_RES, new int[0]);
        if (a.hasValue(R.styleable.RangeSlider_values)) {
            int valuesId = a.getResourceId(R.styleable.RangeSlider_values, 0);
            TypedArray values = a.getResources().obtainTypedArray(valuesId);
            this.setValues(RangeSlider.convertToFloat(values));
        }
        this.minSeparation = a.getDimension(R.styleable.RangeSlider_minSeparation, 0.0f);
        a.recycle();
    }

    @Override
    public void setValues(Float ... values) {
        super.setValues(values);
    }

    @Override
    public void setValues(@NonNull List<Float> values) {
        super.setValues(values);
    }

    @Override
    @NonNull
    public List<Float> getValues() {
        return super.getValues();
    }

    private static List<Float> convertToFloat(TypedArray values) {
        ArrayList<Float> ret = new ArrayList<Float>();
        for (int i = 0; i < values.length(); ++i) {
            ret.add(Float.valueOf(values.getFloat(i, -1.0f)));
        }
        return ret;
    }

    @Override
    public float getMinSeparation() {
        return this.minSeparation;
    }

    public void setMinSeparation(@Dimension float minSeparation) {
        this.minSeparation = minSeparation;
        this.separationUnit = 0;
        this.setSeparationUnit(this.separationUnit);
    }

    public void setMinSeparationValue(float minSeparation) {
        this.minSeparation = minSeparation;
        this.separationUnit = 1;
        this.setSeparationUnit(this.separationUnit);
    }

    @Override
    @NonNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        RangeSliderState sliderState = new RangeSliderState(superState);
        sliderState.minSeparation = this.minSeparation;
        sliderState.separationUnit = this.separationUnit;
        return sliderState;
    }

    @Override
    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        RangeSliderState savedState = (RangeSliderState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.minSeparation = savedState.minSeparation;
        this.separationUnit = savedState.separationUnit;
        this.setSeparationUnit(this.separationUnit);
    }

    static class RangeSliderState
    extends AbsSavedState {
        private float minSeparation;
        private int separationUnit;
        public static final Parcelable.Creator<RangeSliderState> CREATOR = new Parcelable.Creator<RangeSliderState>(){

            public RangeSliderState createFromParcel(Parcel in) {
                return new RangeSliderState(in);
            }

            public RangeSliderState[] newArray(int size) {
                return new RangeSliderState[size];
            }
        };

        RangeSliderState(Parcelable superState) {
            super(superState);
        }

        private RangeSliderState(Parcel in) {
            super(in.readParcelable(RangeSliderState.class.getClassLoader()));
            this.minSeparation = in.readFloat();
            this.separationUnit = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.minSeparation);
            out.writeInt(this.separationUnit);
        }
    }

    public static interface OnSliderTouchListener
    extends BaseOnSliderTouchListener<RangeSlider> {
    }

    public static interface OnChangeListener
    extends BaseOnChangeListener<RangeSlider> {
    }
}

