/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tabs;

import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.tabs.TabIndicatorInterpolator;
import com.google.android.material.tabs.TabLayout;

class ElasticTabIndicatorInterpolator
extends TabIndicatorInterpolator {
    ElasticTabIndicatorInterpolator() {
    }

    private static float decInterp(@FloatRange(from=0.0, to=1.0) float fraction) {
        return (float)Math.sin((double)fraction * Math.PI / 2.0);
    }

    private static float accInterp(@FloatRange(from=0.0, to=1.0) float fraction) {
        return (float)(1.0 - Math.cos((double)fraction * Math.PI / 2.0));
    }

    @Override
    void setIndicatorBoundsForOffset(TabLayout tabLayout, View startTitle, View endTitle, float offset, @NonNull Drawable indicator) {
        float rightFraction;
        float leftFraction;
        boolean isMovingRight;
        RectF startIndicator = ElasticTabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, startTitle);
        RectF endIndicator = ElasticTabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, endTitle);
        boolean bl = isMovingRight = startIndicator.left < endIndicator.left;
        if (isMovingRight) {
            leftFraction = ElasticTabIndicatorInterpolator.accInterp(offset);
            rightFraction = ElasticTabIndicatorInterpolator.decInterp(offset);
        } else {
            leftFraction = ElasticTabIndicatorInterpolator.decInterp(offset);
            rightFraction = ElasticTabIndicatorInterpolator.accInterp(offset);
        }
        indicator.setBounds(AnimationUtils.lerp((int)startIndicator.left, (int)endIndicator.left, leftFraction), indicator.getBounds().top, AnimationUtils.lerp((int)startIndicator.right, (int)endIndicator.right, rightFraction), indicator.getBounds().bottom);
    }
}

