/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.chip.Chip;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.timepicker.TimeModel;
import java.util.Arrays;

class ChipTextInputComboView
extends FrameLayout
implements Checkable {
    private final Chip chip;
    private final TextInputLayout textInputLayout;
    private final EditText editText;
    private TextWatcher watcher;
    private TextView label;

    public ChipTextInputComboView(@NonNull Context context) {
        this(context, null);
    }

    public ChipTextInputComboView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChipTextInputComboView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        this.chip = (Chip)inflater.inflate(R.layout.material_time_chip, (ViewGroup)this, false);
        this.textInputLayout = (TextInputLayout)inflater.inflate(R.layout.material_time_input, (ViewGroup)this, false);
        this.editText = this.textInputLayout.getEditText();
        this.editText.setVisibility(4);
        this.watcher = new TextFormatter();
        this.editText.addTextChangedListener(this.watcher);
        this.updateHintLocales();
        this.addView((View)this.chip);
        this.addView((View)this.textInputLayout);
        this.label = (TextView)this.findViewById(R.id.material_label);
        this.editText.setSaveEnabled(false);
    }

    private void updateHintLocales() {
        if (Build.VERSION.SDK_INT >= 24) {
            Configuration configuration = this.getContext().getResources().getConfiguration();
            LocaleList locales = configuration.getLocales();
            this.editText.setImeHintLocales(locales);
        }
    }

    public boolean isChecked() {
        return this.chip.isChecked();
    }

    public void setChecked(boolean checked) {
        this.chip.setChecked(checked);
        this.editText.setVisibility(checked ? 0 : 4);
        this.chip.setVisibility(checked ? 8 : 0);
        if (this.isChecked()) {
            this.editText.requestFocus();
            if (!TextUtils.isEmpty((CharSequence)this.editText.getText())) {
                this.editText.setSelection(this.editText.getText().length());
            }
        }
    }

    public void toggle() {
        this.chip.toggle();
    }

    public void setText(CharSequence text) {
        this.chip.setText(this.formatText(text));
        if (!TextUtils.isEmpty((CharSequence)this.editText.getText())) {
            this.editText.removeTextChangedListener(this.watcher);
            this.editText.setText(null);
            this.editText.addTextChangedListener(this.watcher);
        }
    }

    private String formatText(CharSequence text) {
        return TimeModel.formatText(this.getResources(), text);
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.chip.setOnClickListener(l);
    }

    public void setTag(int key, Object tag) {
        this.chip.setTag(key, tag);
    }

    public void setHelperText(CharSequence helperText) {
        this.label.setText(helperText);
    }

    public void setCursorVisible(boolean visible) {
        this.editText.setCursorVisible(visible);
    }

    public void addInputFilter(InputFilter filter) {
        InputFilter[] current = this.editText.getFilters();
        InputFilter[] arr = Arrays.copyOf(current, current.length + 1);
        arr[current.length] = filter;
        this.editText.setFilters(arr);
    }

    public TextInputLayout getTextInput() {
        return this.textInputLayout;
    }

    public void setChipDelegate(AccessibilityDelegateCompat clickActionDelegate) {
        ViewCompat.setAccessibilityDelegate((View)this.chip, (AccessibilityDelegateCompat)clickActionDelegate);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateHintLocales();
    }

    private class TextFormatter
    extends TextWatcherAdapter {
        private static final String DEFAULT_TEXT = "00";

        private TextFormatter() {
        }

        @Override
        public void afterTextChanged(Editable editable) {
            if (TextUtils.isEmpty((CharSequence)editable)) {
                ChipTextInputComboView.this.chip.setText(ChipTextInputComboView.this.formatText(DEFAULT_TEXT));
                return;
            }
            ChipTextInputComboView.this.chip.setText(ChipTextInputComboView.this.formatText((CharSequence)editable));
        }
    }
}

