/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import com.google.android.material.timepicker.MaxInputValidator;
import java.util.Arrays;

class TimeModel
implements Parcelable {
    public static final String ZERO_LEADING_NUMBER_FORMAT = "%02d";
    public static final String NUMBER_FORMAT = "%d";
    private final MaxInputValidator minuteInputValidator;
    private final MaxInputValidator hourInputValidator;
    final int format;
    int hour;
    int minute;
    int selection;
    int period;
    public static final Parcelable.Creator<TimeModel> CREATOR = new Parcelable.Creator<TimeModel>(){

        public TimeModel createFromParcel(Parcel in) {
            return new TimeModel(in);
        }

        public TimeModel[] newArray(int size) {
            return new TimeModel[size];
        }
    };

    public TimeModel() {
        this(0);
    }

    public TimeModel(int format) {
        this(0, 0, 10, format);
    }

    public TimeModel(int hour, int minute, int selection, int format) {
        this.hour = hour;
        this.minute = minute;
        this.selection = selection;
        this.format = format;
        this.period = TimeModel.getPeriod(hour);
        this.minuteInputValidator = new MaxInputValidator(59);
        this.hourInputValidator = new MaxInputValidator(format == 1 ? 24 : 12);
    }

    protected TimeModel(Parcel in) {
        this(in.readInt(), in.readInt(), in.readInt(), in.readInt());
    }

    public void setHourOfDay(int hour) {
        this.period = TimeModel.getPeriod(hour);
        this.hour = hour;
    }

    private static int getPeriod(int hourOfDay) {
        return hourOfDay >= 12 ? 1 : 0;
    }

    public void setHour(int hour) {
        if (this.format == 1) {
            this.hour = hour;
            return;
        }
        this.hour = hour % 12 + (this.period == 1 ? 12 : 0);
    }

    public void setMinute(@IntRange(from=0L, to=60L) int minute) {
        this.minute = minute % 60;
    }

    public int getHourForDisplay() {
        if (this.format == 1) {
            return this.hour % 24;
        }
        if (this.hour % 12 == 0) {
            return 12;
        }
        if (this.period == 1) {
            return this.hour - 12;
        }
        return this.hour;
    }

    public MaxInputValidator getMinuteInputValidator() {
        return this.minuteInputValidator;
    }

    public MaxInputValidator getHourInputValidator() {
        return this.hourInputValidator;
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{this.format, this.hour, this.minute, this.selection};
        return Arrays.hashCode(hashedFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeModel)) {
            return false;
        }
        TimeModel that = (TimeModel)o;
        return this.hour == that.hour && this.minute == that.minute && this.format == that.format && this.selection == that.selection;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.hour);
        dest.writeInt(this.minute);
        dest.writeInt(this.selection);
        dest.writeInt(this.format);
    }

    public void setPeriod(int period) {
        if (period != this.period) {
            this.period = period;
            if (this.hour < 12 && period == 1) {
                this.hour += 12;
            } else if (this.hour >= 12 && period == 0) {
                this.hour -= 12;
            }
        }
    }

    public static String formatText(Resources resources, CharSequence text) {
        return TimeModel.formatText(resources, text, ZERO_LEADING_NUMBER_FORMAT);
    }

    public static String formatText(Resources resources, CharSequence text, String format) {
        return String.format(resources.getConfiguration().locale, format, Integer.parseInt(String.valueOf(text)));
    }
}

