/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.PathParser;
import androidx.core.view.animation.PathInterpolatorCompat;
import androidx.transition.PathMotion;
import androidx.transition.PatternPathMotion;
import androidx.transition.Transition;
import androidx.transition.TransitionSet;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.RelativeCornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.transition.MaterialArcMotion;

class TransitionUtils {
    static final int NO_DURATION = -1;
    @AttrRes
    static final int NO_ATTR_RES_ID = 0;
    private static final String EASING_TYPE_CUBIC_BEZIER = "cubic-bezier";
    private static final String EASING_TYPE_PATH = "path";
    private static final String EASING_TYPE_FORMAT_START = "(";
    private static final String EASING_TYPE_FORMAT_END = ")";
    private static final int PATH_TYPE_LINEAR = 0;
    private static final int PATH_TYPE_ARC = 1;
    private static final RectF transformAlphaRectF = new RectF();

    private TransitionUtils() {
    }

    static boolean maybeApplyThemeInterpolator(Transition transition, Context context, @AttrRes int attrResId, TimeInterpolator defaultInterpolator) {
        if (attrResId != 0 && transition.getInterpolator() == null) {
            TimeInterpolator interpolator = TransitionUtils.resolveThemeInterpolator(context, attrResId, defaultInterpolator);
            transition.setInterpolator(interpolator);
            return true;
        }
        return false;
    }

    static boolean maybeApplyThemeDuration(Transition transition, Context context, @AttrRes int attrResId) {
        int duration;
        if (attrResId != 0 && transition.getDuration() == -1L && (duration = MaterialAttributes.resolveInteger(context, attrResId, -1)) != -1) {
            transition.setDuration((long)duration);
            return true;
        }
        return false;
    }

    static boolean maybeApplyThemePath(Transition transition, Context context, @AttrRes int attrResId) {
        PathMotion pathMotion;
        if (attrResId != 0 && (pathMotion = TransitionUtils.resolveThemePath(context, attrResId)) != null) {
            transition.setPathMotion(pathMotion);
            return true;
        }
        return false;
    }

    static TimeInterpolator resolveThemeInterpolator(Context context, @AttrRes int attrResId, @NonNull TimeInterpolator defaultInterpolator) {
        TypedValue easingValue = new TypedValue();
        if (context.getTheme().resolveAttribute(attrResId, easingValue, true)) {
            if (easingValue.type != 3) {
                throw new IllegalArgumentException("Motion easing theme attribute must be a string");
            }
            String easingString = String.valueOf(easingValue.string);
            if (TransitionUtils.isEasingType(easingString, EASING_TYPE_CUBIC_BEZIER)) {
                String controlPointsString = TransitionUtils.getEasingContent(easingString, EASING_TYPE_CUBIC_BEZIER);
                String[] controlPoints = controlPointsString.split(",");
                if (controlPoints.length != 4) {
                    throw new IllegalArgumentException("Motion easing theme attribute must have 4 control points if using bezier curve format; instead got: " + controlPoints.length);
                }
                float controlX1 = TransitionUtils.getControlPoint(controlPoints, 0);
                float controlY1 = TransitionUtils.getControlPoint(controlPoints, 1);
                float controlX2 = TransitionUtils.getControlPoint(controlPoints, 2);
                float controlY2 = TransitionUtils.getControlPoint(controlPoints, 3);
                return PathInterpolatorCompat.create((float)controlX1, (float)controlY1, (float)controlX2, (float)controlY2);
            }
            if (TransitionUtils.isEasingType(easingString, EASING_TYPE_PATH)) {
                String path = TransitionUtils.getEasingContent(easingString, EASING_TYPE_PATH);
                return PathInterpolatorCompat.create((Path)PathParser.createPathFromPathData((String)path));
            }
            throw new IllegalArgumentException("Invalid motion easing type: " + easingString);
        }
        return defaultInterpolator;
    }

    private static boolean isEasingType(String easingString, String easingType) {
        return easingString.startsWith(easingType + EASING_TYPE_FORMAT_START) && easingString.endsWith(EASING_TYPE_FORMAT_END);
    }

    private static String getEasingContent(String easingString, String easingType) {
        return easingString.substring(easingType.length() + EASING_TYPE_FORMAT_START.length(), easingString.length() - EASING_TYPE_FORMAT_END.length());
    }

    private static float getControlPoint(String[] controlPoints, int index) {
        float controlPoint = Float.parseFloat(controlPoints[index]);
        if (controlPoint < 0.0f || controlPoint > 1.0f) {
            throw new IllegalArgumentException("Motion easing control point value must be between 0 and 1; instead got: " + controlPoint);
        }
        return controlPoint;
    }

    @Nullable
    static PathMotion resolveThemePath(Context context, @AttrRes int attrResId) {
        TypedValue pathValue = new TypedValue();
        if (context.getTheme().resolveAttribute(attrResId, pathValue, true)) {
            if (pathValue.type == 16) {
                int pathInt = pathValue.data;
                if (pathInt == 0) {
                    return null;
                }
                if (pathInt == 1) {
                    return new MaterialArcMotion();
                }
                throw new IllegalArgumentException("Invalid motion path type: " + pathInt);
            }
            if (pathValue.type == 3) {
                String pathString = String.valueOf(pathValue.string);
                return new PatternPathMotion(PathParser.createPathFromPathData((String)pathString));
            }
            throw new IllegalArgumentException("Motion path theme attribute must either be an enum value or path data string");
        }
        return null;
    }

    static ShapeAppearanceModel convertToRelativeCornerSizes(ShapeAppearanceModel shapeAppearanceModel, final RectF bounds) {
        return shapeAppearanceModel.withTransformedCornerSizes(new ShapeAppearanceModel.CornerSizeUnaryOperator(){

            @Override
            @NonNull
            public CornerSize apply(@NonNull CornerSize cornerSize) {
                return cornerSize instanceof RelativeCornerSize ? cornerSize : new RelativeCornerSize(cornerSize.getCornerSize(bounds) / bounds.height());
            }
        });
    }

    static ShapeAppearanceModel transformCornerSizes(ShapeAppearanceModel shapeAppearanceModel1, ShapeAppearanceModel shapeAppearanceModel2, RectF shapeAppearanceModel1Bounds, CornerSizeBinaryOperator op) {
        ShapeAppearanceModel shapeAppearanceModel = TransitionUtils.isShapeAppearanceSignificant(shapeAppearanceModel1, shapeAppearanceModel1Bounds) ? shapeAppearanceModel1 : shapeAppearanceModel2;
        return shapeAppearanceModel.toBuilder().setTopLeftCornerSize(op.apply(shapeAppearanceModel1.getTopLeftCornerSize(), shapeAppearanceModel2.getTopLeftCornerSize())).setTopRightCornerSize(op.apply(shapeAppearanceModel1.getTopRightCornerSize(), shapeAppearanceModel2.getTopRightCornerSize())).setBottomLeftCornerSize(op.apply(shapeAppearanceModel1.getBottomLeftCornerSize(), shapeAppearanceModel2.getBottomLeftCornerSize())).setBottomRightCornerSize(op.apply(shapeAppearanceModel1.getBottomRightCornerSize(), shapeAppearanceModel2.getBottomRightCornerSize())).build();
    }

    private static boolean isShapeAppearanceSignificant(ShapeAppearanceModel shapeAppearanceModel, RectF bounds) {
        return shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(bounds) != 0.0f || shapeAppearanceModel.getTopRightCornerSize().getCornerSize(bounds) != 0.0f || shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(bounds) != 0.0f || shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(bounds) != 0.0f;
    }

    static float lerp(float startValue, float endValue, float fraction) {
        return startValue + fraction * (endValue - startValue);
    }

    static float lerp(float startValue, float endValue, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @FloatRange(from=0.0, to=1.0) float fraction) {
        return TransitionUtils.lerp(startValue, endValue, startFraction, endFraction, fraction, false);
    }

    static float lerp(float startValue, float endValue, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @FloatRange(from=0.0) float fraction, boolean allowOvershoot) {
        if (allowOvershoot && (fraction < 0.0f || fraction > 1.0f)) {
            return TransitionUtils.lerp(startValue, endValue, fraction);
        }
        if (fraction < startFraction) {
            return startValue;
        }
        if (fraction > endFraction) {
            return endValue;
        }
        return TransitionUtils.lerp(startValue, endValue, (fraction - startFraction) / (endFraction - startFraction));
    }

    static int lerp(int startValue, int endValue, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction < startFraction) {
            return startValue;
        }
        if (fraction > endFraction) {
            return endValue;
        }
        return (int)TransitionUtils.lerp(startValue, endValue, (fraction - startFraction) / (endFraction - startFraction));
    }

    static ShapeAppearanceModel lerp(ShapeAppearanceModel startValue, ShapeAppearanceModel endValue, final RectF startBounds, final RectF endBounds, final @FloatRange(from=0.0, to=1.0) float startFraction, final @FloatRange(from=0.0, to=1.0) float endFraction, final @FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction < startFraction) {
            return startValue;
        }
        if (fraction > endFraction) {
            return endValue;
        }
        return TransitionUtils.transformCornerSizes(startValue, endValue, startBounds, new CornerSizeBinaryOperator(){

            @Override
            @NonNull
            public CornerSize apply(@NonNull CornerSize cornerSize1, @NonNull CornerSize cornerSize2) {
                float startCornerSize = cornerSize1.getCornerSize(startBounds);
                float endCornerSize = cornerSize2.getCornerSize(endBounds);
                float cornerSize = TransitionUtils.lerp(startCornerSize, endCornerSize, startFraction, endFraction, fraction);
                return new AbsoluteCornerSize(cornerSize);
            }
        });
    }

    static Shader createColorShader(@ColorInt int color2) {
        return new LinearGradient(0.0f, 0.0f, 0.0f, 0.0f, color2, color2, Shader.TileMode.CLAMP);
    }

    static View findDescendantOrAncestorById(View view, @IdRes int viewId) {
        View descendant = view.findViewById(viewId);
        if (descendant != null) {
            return descendant;
        }
        return TransitionUtils.findAncestorById(view, viewId);
    }

    static View findAncestorById(View view, @IdRes int ancestorId) {
        String resourceName = view.getResources().getResourceName(ancestorId);
        while (view != null) {
            if (view.getId() == ancestorId) {
                return view;
            }
            ViewParent parent = view.getParent();
            if (!(parent instanceof View)) break;
            view = (View)parent;
        }
        throw new IllegalArgumentException(resourceName + " is not a valid ancestor");
    }

    static RectF getRelativeBounds(View view) {
        return new RectF((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
    }

    static Rect getRelativeBoundsRect(View view) {
        return new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
    }

    static RectF getLocationOnScreen(View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getWidth();
        int bottom = top + view.getHeight();
        return new RectF((float)left, (float)top, (float)right, (float)bottom);
    }

    @NonNull
    static <T> T defaultIfNull(@Nullable T value, @NonNull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    static float calculateArea(@NonNull RectF bounds) {
        return bounds.width() * bounds.height();
    }

    private static int saveLayerAlphaCompat(Canvas canvas, Rect bounds, int alpha) {
        transformAlphaRectF.set(bounds);
        if (Build.VERSION.SDK_INT >= 21) {
            return canvas.saveLayerAlpha(transformAlphaRectF, alpha);
        }
        return canvas.saveLayerAlpha(TransitionUtils.transformAlphaRectF.left, TransitionUtils.transformAlphaRectF.top, TransitionUtils.transformAlphaRectF.right, TransitionUtils.transformAlphaRectF.bottom, alpha, 31);
    }

    static void transform(Canvas canvas, Rect bounds, float dx, float dy, float scale, int alpha, CanvasOperation op) {
        if (alpha <= 0) {
            return;
        }
        int checkpoint = canvas.save();
        canvas.translate(dx, dy);
        canvas.scale(scale, scale);
        if (alpha < 255) {
            TransitionUtils.saveLayerAlphaCompat(canvas, bounds, alpha);
        }
        op.run(canvas);
        canvas.restoreToCount(checkpoint);
    }

    static void maybeAddTransition(TransitionSet transitionSet, @Nullable Transition transition) {
        if (transition != null) {
            transitionSet.addTransition(transition);
        }
    }

    static void maybeRemoveTransition(TransitionSet transitionSet, @Nullable Transition transition) {
        if (transition != null) {
            transitionSet.removeTransition(transition);
        }
    }

    static interface CanvasOperation {
        public void run(Canvas var1);
    }

    static interface CornerSizeBinaryOperator {
        @NonNull
        public CornerSize apply(@NonNull CornerSize var1, @NonNull CornerSize var2);
    }
}

