/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.trusted.ConnectionHolder;
import androidx.browser.trusted.FutureUtils;
import androidx.browser.trusted.Token;
import androidx.browser.trusted.TrustedWebActivityServiceConnection;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public final class TrustedWebActivityServiceConnectionPool {
    private static final String TAG = "TWAConnectionPool";
    private final Context mContext;
    private final Map<Uri, ConnectionHolder> mConnections = new HashMap<Uri, ConnectionHolder>();

    private TrustedWebActivityServiceConnectionPool(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
    }

    @NonNull
    public static TrustedWebActivityServiceConnectionPool create(@NonNull Context context) {
        return new TrustedWebActivityServiceConnectionPool(context);
    }

    @MainThread
    @NonNull
    public ListenableFuture<TrustedWebActivityServiceConnection> connect(@NonNull Uri scope, @NonNull Set<Token> possiblePackages, @NonNull Executor executor) {
        ConnectionHolder connection = this.mConnections.get(scope);
        if (connection != null) {
            return connection.getServiceWrapper();
        }
        Intent bindServiceIntent = this.createServiceIntent(this.mContext, scope, possiblePackages, true);
        if (bindServiceIntent == null) {
            return FutureUtils.immediateFailedFuture(new IllegalArgumentException("No service exists for scope"));
        }
        ConnectionHolder newConnection = new ConnectionHolder(() -> this.mConnections.remove(scope));
        this.mConnections.put(scope, newConnection);
        new BindToServiceAsyncTask(this.mContext, bindServiceIntent, newConnection).executeOnExecutor(executor, new Void[0]);
        return newConnection.getServiceWrapper();
    }

    @MainThread
    public boolean serviceExistsForScope(@NonNull Uri scope, @NonNull Set<Token> possiblePackages) {
        if (this.mConnections.get(scope) != null) {
            return true;
        }
        return this.createServiceIntent(this.mContext, scope, possiblePackages, false) != null;
    }

    void unbindAllConnections() {
        for (ConnectionHolder connection : this.mConnections.values()) {
            this.mContext.unbindService((ServiceConnection)connection);
        }
        this.mConnections.clear();
    }

    @Nullable
    private Intent createServiceIntent(Context appContext, Uri scope, Set<Token> possiblePackages, boolean shouldLog) {
        ResolveInfo info2;
        if (possiblePackages == null || possiblePackages.size() == 0) {
            return null;
        }
        Intent scopeResolutionIntent = new Intent();
        scopeResolutionIntent.setData(scope);
        scopeResolutionIntent.setAction("android.intent.action.VIEW");
        List candidateActivities = appContext.getPackageManager().queryIntentActivities(scopeResolutionIntent, 65536);
        String resolvedPackage = null;
        block0: for (ResolveInfo info2 : candidateActivities) {
            String packageName = info2.activityInfo.packageName;
            for (Token possiblePackage : possiblePackages) {
                if (!possiblePackage.matches(packageName, appContext.getPackageManager())) continue;
                resolvedPackage = packageName;
                continue block0;
            }
        }
        if (resolvedPackage == null) {
            if (shouldLog) {
                Log.w((String)TAG, (String)("No TWA candidates for " + scope + " have been registered."));
            }
            return null;
        }
        Intent serviceResolutionIntent = new Intent();
        serviceResolutionIntent.setPackage(resolvedPackage);
        serviceResolutionIntent.setAction("android.support.customtabs.trusted.TRUSTED_WEB_ACTIVITY_SERVICE");
        info2 = appContext.getPackageManager().resolveService(serviceResolutionIntent, 131072);
        if (info2 == null) {
            if (shouldLog) {
                Log.w((String)TAG, (String)("Could not find TWAService for " + resolvedPackage));
            }
            return null;
        }
        if (shouldLog) {
            Log.i((String)TAG, (String)("Found " + info2.serviceInfo.name + " to handle request for " + scope));
        }
        Intent finalIntent = new Intent();
        finalIntent.setComponent(new ComponentName(resolvedPackage, info2.serviceInfo.name));
        return finalIntent;
    }

    static class BindToServiceAsyncTask
    extends AsyncTask<Void, Void, Exception> {
        private final Context mAppContext;
        private final Intent mIntent;
        private final ConnectionHolder mConnection;

        BindToServiceAsyncTask(Context context, Intent intent, ConnectionHolder connection) {
            this.mAppContext = context.getApplicationContext();
            this.mIntent = intent;
            this.mConnection = connection;
        }

        @Nullable
        protected Exception doInBackground(Void ... voids) {
            try {
                if (this.mAppContext.bindService(this.mIntent, (ServiceConnection)this.mConnection, 4097)) {
                    return null;
                }
                this.mAppContext.unbindService((ServiceConnection)this.mConnection);
                return new IllegalStateException("Could not bind to the service");
            }
            catch (SecurityException e) {
                Log.w((String)TrustedWebActivityServiceConnectionPool.TAG, (String)"SecurityException while binding.", (Throwable)e);
                return e;
            }
        }

        protected void onPostExecute(Exception bindingException) {
            if (bindingException != null) {
                this.mConnection.cancel(bindingException);
            }
        }
    }
}

