/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.transition.R;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ViewGroupUtilsApi14 {
    private static final String TAG = "ViewGroupUtilsApi14";
    private static final int LAYOUT_TRANSITION_CHANGING = 4;
    private static LayoutTransition sEmptyLayoutTransition;
    private static Field sLayoutSuppressedField;
    private static boolean sLayoutSuppressedFieldFetched;
    private static Method sCancelMethod;
    private static boolean sCancelMethodFetched;

    static void suppressLayout(@NonNull ViewGroup group, boolean suppress) {
        if (sEmptyLayoutTransition == null) {
            sEmptyLayoutTransition = new LayoutTransition(){

                public boolean isChangingLayout() {
                    return true;
                }
            };
            sEmptyLayoutTransition.setAnimator(2, null);
            sEmptyLayoutTransition.setAnimator(0, null);
            sEmptyLayoutTransition.setAnimator(1, null);
            sEmptyLayoutTransition.setAnimator(3, null);
            sEmptyLayoutTransition.setAnimator(4, null);
        }
        if (suppress) {
            LayoutTransition layoutTransition = group.getLayoutTransition();
            if (layoutTransition != null) {
                if (layoutTransition.isRunning()) {
                    ViewGroupUtilsApi14.cancelLayoutTransition(layoutTransition);
                }
                if (layoutTransition != sEmptyLayoutTransition) {
                    group.setTag(R.id.transition_layout_save, (Object)layoutTransition);
                }
            }
            group.setLayoutTransition(sEmptyLayoutTransition);
        } else {
            LayoutTransition layoutTransition;
            group.setLayoutTransition(null);
            if (!sLayoutSuppressedFieldFetched) {
                try {
                    sLayoutSuppressedField = ViewGroup.class.getDeclaredField("mLayoutSuppressed");
                    sLayoutSuppressedField.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    Log.i((String)TAG, (String)"Failed to access mLayoutSuppressed field by reflection");
                }
                sLayoutSuppressedFieldFetched = true;
            }
            boolean layoutSuppressed = false;
            if (sLayoutSuppressedField != null) {
                try {
                    layoutSuppressed = sLayoutSuppressedField.getBoolean(group);
                    if (layoutSuppressed) {
                        sLayoutSuppressedField.setBoolean(group, false);
                    }
                }
                catch (IllegalAccessException e) {
                    Log.i((String)TAG, (String)"Failed to get mLayoutSuppressed field by reflection");
                }
            }
            if (layoutSuppressed) {
                group.requestLayout();
            }
            if ((layoutTransition = (LayoutTransition)group.getTag(R.id.transition_layout_save)) != null) {
                group.setTag(R.id.transition_layout_save, null);
                group.setLayoutTransition(layoutTransition);
            }
        }
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    private static void cancelLayoutTransition(LayoutTransition t) {
        if (!sCancelMethodFetched) {
            try {
                sCancelMethod = LayoutTransition.class.getDeclaredMethod("cancel", new Class[0]);
                sCancelMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to access cancel method by reflection");
            }
            sCancelMethodFetched = true;
        }
        if (sCancelMethod != null) {
            try {
                sCancelMethod.invoke((Object)t, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.i((String)TAG, (String)"Failed to access cancel method by reflection");
            }
            catch (InvocationTargetException e) {
                Log.i((String)TAG, (String)"Failed to invoke cancel method by reflection");
            }
        }
    }

    private ViewGroupUtilsApi14() {
    }
}

