/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NavDeepLinkRequest {
    private final Uri mUri;
    private final String mAction;
    private final String mMimeType;

    NavDeepLinkRequest(@NonNull Intent intent) {
        this(intent.getData(), intent.getAction(), intent.getType());
    }

    NavDeepLinkRequest(@Nullable Uri uri, @Nullable String action, @Nullable String mimeType) {
        this.mUri = uri;
        this.mAction = action;
        this.mMimeType = mimeType;
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    @Nullable
    public String getAction() {
        return this.mAction;
    }

    @Nullable
    public String getMimeType() {
        return this.mMimeType;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NavDeepLinkRequest");
        sb.append("{");
        if (this.mUri != null) {
            sb.append(" uri=");
            sb.append(this.mUri.toString());
        }
        if (this.mAction != null) {
            sb.append(" action=");
            sb.append(this.mAction);
        }
        if (this.mMimeType != null) {
            sb.append(" mimetype=");
            sb.append(this.mMimeType);
        }
        sb.append(" }");
        return sb.toString();
    }

    public static final class Builder {
        private Uri mUri;
        private String mAction;
        private String mMimeType;

        private Builder() {
        }

        @NonNull
        public static Builder fromUri(@NonNull Uri uri) {
            Builder builder = new Builder();
            builder.setUri(uri);
            return builder;
        }

        @NonNull
        public static Builder fromAction(@NonNull String action) {
            if (action.isEmpty()) {
                throw new IllegalArgumentException("The NavDeepLinkRequest cannot have an empty action.");
            }
            Builder builder = new Builder();
            builder.setAction(action);
            return builder;
        }

        @NonNull
        public static Builder fromMimeType(@NonNull String mimeType) {
            Builder builder = new Builder();
            builder.setMimeType(mimeType);
            return builder;
        }

        @NonNull
        public Builder setUri(@NonNull Uri uri) {
            this.mUri = uri;
            return this;
        }

        @NonNull
        public Builder setAction(@NonNull String action) {
            if (action.isEmpty()) {
                throw new IllegalArgumentException("The NavDeepLinkRequest cannot have an empty action.");
            }
            this.mAction = action;
            return this;
        }

        @NonNull
        public Builder setMimeType(@NonNull String mimeType) {
            Pattern mimeTypePattern = Pattern.compile("^[-\\w*.]+/[-\\w+*.]+$");
            Matcher mimeTypeMatcher = mimeTypePattern.matcher(mimeType);
            if (!mimeTypeMatcher.matches()) {
                throw new IllegalArgumentException("The given mimeType " + mimeType + " does not match to required \"type/subtype\" format");
            }
            this.mMimeType = mimeType;
            return this;
        }

        @NonNull
        public NavDeepLinkRequest build() {
            return new NavDeepLinkRequest(this.mUri, this.mAction, this.mMimeType);
        }
    }
}

