﻿using SFI.COMM.BASESYSTEM;
using SFI.COMM.ENTITY;
using SFI.COMM.SESSION;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SFI.COMM.BUSINESS
{
    public static class WebServerController
    {
        public static async Task<ObjectResult<T>> RunCommand<T>(string ClientKey_, CommandTypes CommandType_, object Data_ = null, Action<ObjectResult<T>> CompletedActionForLongCommand_ = null) where T : class
        {
            if (!LicenseController.CheckLicense(ClientKey_))
                return await Task.Run(() => new ObjectResult<T>() { Success = false, Code = "INVALID-LICENSE", Message = "Invalid license key!" });


            if (CommandType_.CommandCategory() == CommandCategories.Standart)
                return await CommandController.CommandCall<T>(ClientKey_, CommandType_, Data_);
            else
            {
                string statusKey_ = $"STT-{DateTime.Now.Ticks}";
                CommandStatusList.Add(new CommandStatus() { StatusKey = statusKey_ });
                Task.Run(() => WebServerController.RunComplexCommands<T>(ClientKey_, CommandType_, statusKey_, Data_, CompletedActionForLongCommand_));
                return await Task.Run(() => new ObjectResult<T>() { Success = true, StatusKey = statusKey_ });
            }
        }


        public static async void RunComplexCommands<T>(string ClientKey_, CommandTypes CommandType_, string StatusKey_, object Data_ = null, Action<ObjectResult<T>> CompletedAction_ = null) where T : class
        {
            try
            {
                ObjectResult<string> result_ = null;

                if (CommandType_ == CommandTypes.Do_Dir_Backup || CommandType_ == CommandTypes.Do_SQL_Backup)
                {
                    result_ = await CommandController.LongCommandCall<string>(ClientKey_, CommandType_, StatusKey_, Data_);
                    if (!result_.Success)
                    {
                        WebServerController.CommandStatusSet(StatusKey_, "FAILED");
                        throw new Exception(result_.Message);
                    }
                    result_ = await CommandController.LongCommandCall<string>(ClientKey_, CommandTypes.StartGoogleUpload, StatusKey_, result_.Data);
                    if (!result_.Success)
                    {
                        WebServerController.CommandStatusSet(StatusKey_, "FAILED");
                        throw new Exception(result_.Message);
                    }
                }

                if (CommandType_ == CommandTypes.Do_Dir_Restore || CommandType_ == CommandTypes.Do_SQL_Restore)
                {
                    result_ = await CommandController.LongCommandCall<string>(ClientKey_, CommandTypes.StartGoogleDownload, StatusKey_, Data_);
                    if (!result_.Success)
                    {
                        WebServerController.CommandStatusSet(StatusKey_, "FAILED");
                        throw new Exception(result_.Message);
                    }
                    result_ = await CommandController.LongCommandCall<string>(ClientKey_, CommandType_, StatusKey_, result_.Data);
                    if (!result_.Success)
                    {
                        WebServerController.CommandStatusSet(StatusKey_, "FAILED");
                        throw new Exception(result_.Message);
                    }
                }

                if (CompletedAction_ != null)
                    CompletedAction_(new ObjectResult<T>() { Success = true });
            }
            catch (Exception exc)
            {
                if (CompletedAction_ != null)
                    CompletedAction_(new ObjectResult<T>() { Success = false, Code = $"CLIENTKEY=>{ClientKey_}: COMMAND=>{CommandType_}", Message = exc.StackTrace });
            }
        }




        private static ObservableCollection<CommandStatus> CommandStatusList = new ObservableCollection<CommandStatus>();
        public static void CommandStatusSet(string StatusKey_, string StatusValue_)
        {
            CommandStatus commandStatus_ = WebServerController.CommandStatusList.Where(t => t.StatusKey == StatusKey_).FirstOrDefault();
            if (commandStatus_ != null)
                commandStatus_.StatusValue = StatusValue_;
        }
        public static string CommandStatusGet(string StatusKey_) => WebServerController.CommandStatusList.Where(t => t.StatusKey == StatusKey_)?.FirstOrDefault()?.StatusValue;


    }
}
