﻿using SFI.COMM.BASESYSTEM;
using SFI.COMM.ENTITY;
using SFI.COMM.SESSION;
using System;
using System.Collections.Generic;
using System.Text;
using static SFI.COMM.BASESYSTEM.CommandController;

namespace SFI.COMM.BUSINESS
{
    public static class WindowsServiceController
    {
        public static event CommandEventDelegate SQLSettingsRunEvent;
        public static event CommandEventDelegate SQLListRunEvent;
        public static event CommandEventDelegate SQLBackupRunEvent;
        public static event CommandEventDelegate SQLRestoreRunEvent;
        public static event CommandEventDelegate DirListRunEvent;
        public static event CommandEventDelegate DirBackupRunEvent;
        public static event CommandEventDelegate DirRestoreRunEvent;

        public static event CommandEventDelegate GoogleUploadRunEvent;
        public static event CommandEventDelegate GoogleDownloadRunEvent;



        public static object RunCommand(ChannelCommand Command_)
        {
            switch (Command_.CommandType)
            {
                case (int)CommandTypes.Get_Dir_List:
                    if (DirListRunEvent != null)
                        return DirListRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.Get_SQL_List:
                    if (SQLListRunEvent != null)
                        return SQLListRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.Do_SQL_Settings:
                    if (SQLSettingsRunEvent != null)
                        return SQLSettingsRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.Do_SQL_Backup:
                    if (SQLBackupRunEvent != null)
                        return SQLBackupRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.Do_SQL_Restore:
                    if (SQLRestoreRunEvent != null)
                        return SQLBackupRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.Do_Dir_Backup:
                    if (DirBackupRunEvent != null)
                        return DirBackupRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.Do_Dir_Restore:
                    if (DirRestoreRunEvent != null)
                        return DirRestoreRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.StartGoogleUpload:
                    if (GoogleUploadRunEvent != null)
                        return GoogleUploadRunEvent.Invoke(Command_);
                    break;

                case (int)CommandTypes.StartGoogleDownload:
                    if (GoogleDownloadRunEvent != null)
                        return GoogleDownloadRunEvent.Invoke(Command_);
                    break;
            }

            return null;
        }


        public static void UpdateStatus(string StatusKey_, string StatusValue_) => CommunicationController.Publish(new ChannelCommand()
        {
            CommandKey = DateTime.Now.Ticks,
            CommandType = (int)CommandTypes.StatusUpdate,
            StatusKey = StatusKey_,
            StatusValue = StatusValue_
        });

    }
}
