﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SFI.COMM.LIB.Redis
{
    public static class Channel
    {
        public static string ClientToken { get; set; } 
        public static bool IsChannelActive { get; set; }



        public static RedisSub RedisChannel { get; set; }
        public static Redis _Redis { get; set; }
        public static Redis Redis
        {
            get
            {
                if (Channel._Redis == null)
                    Channel._Redis = new Redis(Constants.RtsHost, Constants.RtsPort, Constants.RtsPassword);

                return _Redis;
            }
        }




        public static RedisSub PublisherRedisChannel { get; set; }
        public static Redis _PublisherRedis { get; set; }
        public static Redis PublisherRedis
        {
            get
            {
                if (Channel._PublisherRedis == null)
                    Channel._PublisherRedis = new Redis(Constants.RtsHost, Constants.RtsPort, Constants.RtsPassword);

                return _PublisherRedis;
            }
        }




        public static void Start(string channelToken, string clientToken)
        {
            Constants.RtsBotChannelToken = channelToken;
            Channel.Start(clientToken);
        }

        public static void Start(string clientToken)
        {
            Channel.ClientToken = clientToken;

            if (Channel.RedisChannel != null)
                Channel.RedisChannel.Dispose();

            Channel.RedisChannel = new RedisSub(Channel.Redis.Host, Channel.Redis.Port, Channel.Redis.Password);
            Channel.RedisChannel.MessageReceived += (s, e) =>
            {
                try
                {
                    Console.WriteLine("rts uzerinden data geldi = " + e.message);

                    Channel.IsChannelActive = true;
                    Commander.Receiver(e.message.ToString());  
                }
                catch (Exception ex)
                {

                }
            };
            Channel.RedisChannel.SubscribeReceived += (s, e) =>
            {
                Channel.IsChannelActive = true;
            };
            Channel.RedisChannel.UnsubscribeReceived += (s, e) =>
            {
                Channel.IsChannelActive = false;
            };
            Channel.RedisChannel.SendSubCommandFree("client", "setname", "subscriber-" + Channel.ClientToken);
            Channel.RedisChannel.Subscribe(Constants.RtsBotChannelToken);


            Channel.StartPublisher();
        }


        public static void StartPublisher()
        {
            if (Channel.PublisherRedisChannel != null)
                Channel.PublisherRedisChannel.Dispose();

            Channel.PublisherRedisChannel = new RedisSub(Channel.Redis.Host, Channel.Redis.Port, Channel.Redis.Password);
            Channel.PublisherRedisChannel.SendSubCommandFree("client", "setname", "publisher-" + Channel.ClientToken);
        }


        public static void SendData(string jsonData)
        {
            Channel.PublisherRedisChannel.SendCommand("PUBLISH", $@"{Constants.RtsBotChannelToken}", $@"{jsonData}");
        }

        public static void Stop()
        {
            try
            {
                Channel.RedisChannel.Dispose();
            }
            catch (Exception ex) { }

            try
            {
                Channel.PublisherRedisChannel.Dispose();
            }
            catch (Exception ex) { }
        }
    }
}
