﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SFI.COMM.LIB.Redis
{

    public class TransferCommand : IDisposable
    {
        public string CommandKey { get; set; }
        public string ReceiverKey { get; set; }
        public string SenderKey { get; set; }
        public CommandCollection Command { get; set; }
        public object Parameter { get; set; }

        public string Name
        {
            get
            {
                return this.Command.ToString();
            }
            set

            {
                this.Command = value.ToEnum<CommandCollection>();
            }
        }


        public List<CommandParameter> Parameters = new List<CommandParameter>();

        public void Dispose()
        {
            GC.SuppressFinalize(this);
        }
    }
}
