﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace SFI.COMM.LIB
{
    [DefaultProperty("Returned")]
    public class VResult<T>
    {
        public VResult()
        {
        }
        public T Returned { get; set; }
        public static implicit operator T(VResult<T> _res)
        {
            return _res.Returned;
        }
    }
     
    public class Inheritance
    { 
        public static VResult<T> GetValue<T>(string _strValue) where T : struct
        {
            T _prop = default(T);

            return GetValue<T>(ref _prop, _strValue);
        }         
        public static VResult<T> GetValue<T>(ref T _prop, string _strValue) where T : struct
        {
            VResult<T> _ret = new VResult<T>();

            T? _gValue = null;
            if (typeof(T).Name == "String")
            {
                _gValue = _strValue as T?;
            }
            if (typeof(T).Name.IndexOf("Int64") == 0)
            {
                if (_strValue.IndexOf(",") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf(","));
                if (_strValue.IndexOf(".") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf("."));
                _gValue = _strValue.ToInt64() as T?;
            }
            else if (typeof(T).Name.IndexOf("Int32") == 0)
            {
                if (_strValue.IndexOf(",") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf(","));
                if (_strValue.IndexOf(".") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf("."));
                if (string.IsNullOrEmpty(_strValue))
                    _strValue = "0";
                _gValue = _strValue.ToInt() as T?;
            }
            else if (typeof(T).Name.IndexOf("Int16") == 0)
            {
                if (_strValue.IndexOf(",") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf(","));
                if (_strValue.IndexOf(".") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf("."));
                if (string.IsNullOrEmpty(_strValue))
                    _strValue = "0";
                _gValue = Convert.ToInt16(_strValue) as T?;
            }
            else if (typeof(T).Name.IndexOf("Int") == 0)
            {
                if (_strValue.IndexOf(",") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf(","));
                if (_strValue.IndexOf(".") > 0)
                    _strValue = _strValue.Substring(0, _strValue.IndexOf("."));
                if (string.IsNullOrEmpty(_strValue))
                    _strValue = "0";
                _gValue = int.Parse(_strValue) as T?;
            }
            if (typeof(T).Name.IndexOf("DateTime") == 0)
            {
                _gValue = Convert.ToDateTime(_strValue) as T?;
            }
            if (typeof(T).Name.IndexOf("String") == 0)
            {
                _gValue = _strValue.ToString() as T?;
            }
            if (typeof(T).Name == "Double")
            {
                if (string.IsNullOrEmpty(_strValue))
                    _strValue = "0";
                _gValue = Double.Parse(_strValue.Replace(System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberGroupSeparator, System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator).Replace(".", System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator).Replace(",", System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator)) as T?;
            }
            if (typeof(T).Name == "Decimal")
            {
                if (string.IsNullOrEmpty(_strValue))
                    _strValue = "0";
                _gValue = Convert.ToDecimal(_strValue.Replace(System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberGroupSeparator, System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator).Replace(".", System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator).Replace(",", System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator)) as T?;
            }
            if (typeof(T).Name == "Boolean")
            {
                if (_strValue == "0")
                {
                    _gValue = false as T?;
                }
                else if (_strValue == "1")
                {
                    _gValue = true as T?;
                }
                else if (string.IsNullOrEmpty(_strValue))
                {
                    _gValue = false as T?;
                }
                else
                {
                    _gValue = bool.Parse(_strValue) as T?;
                }
            }
            if (typeof(T).Name == "Byte")
            {
                _gValue = byte.Parse(_strValue) as T?;
            }
    



            if (_gValue != null)
            {
                _prop = (T)_gValue;
                _ret.Returned = (T)_gValue;
            }
            else
            {
                _ret = null;
            }

            return _ret;
        } 
    }

    public class StringValue : System.Attribute
    {
        private string _value;

        public StringValue(string value)
        {
            _value = value;
        }

        public string Value
        {
            get { return _value; }
        }

    }

}
